/*
 * Decompiled with CFR 0.152.
 */
package bg.dalexiev.bender.content;

import android.content.ContentValues;
import android.support.annotation.NonNull;
import bg.dalexiev.bender.util.Preconditions;
import java.util.ArrayList;
import java.util.List;

class ContentValuesBuilder {
    private int mPosition;
    private final List<ContentValues> mContentValues = new ArrayList<ContentValues>(10);

    ContentValuesBuilder() {
        this.mContentValues.add(new ContentValues());
    }

    private ContentValues getCurrent() {
        ContentValues contentValues = this.mContentValues.get(this.mPosition);
        Preconditions.notNull(contentValues, "Invalid content builder state: value at position " + this.mPosition + " is null");
        return contentValues;
    }

    void newValue() {
        ++this.mPosition;
        this.mContentValues.add(new ContentValues());
    }

    void setNull(@NonNull String column) {
        Preconditions.argumentNotNull(column, "Column is required");
        this.getCurrent().putNull(column);
    }

    void set(@NonNull String column, byte value) {
        Preconditions.argumentNotNull(column, "Column is required");
        this.getCurrent().put(column, Byte.valueOf(value));
    }

    void set(@NonNull String column, short value) {
        Preconditions.argumentNotNull(column, "Column is required");
        this.getCurrent().put(column, Short.valueOf(value));
    }

    void set(@NonNull String column, int value) {
        Preconditions.argumentNotNull(column, "Column is required");
        this.getCurrent().put(column, Integer.valueOf(value));
    }

    void set(@NonNull String column, long value) {
        Preconditions.argumentNotNull(column, "Column is required");
        this.getCurrent().put(column, Long.valueOf(value));
    }

    void set(@NonNull String column, float value) {
        Preconditions.argumentNotNull(column, "Column is required");
        this.getCurrent().put(column, Float.valueOf(value));
    }

    void set(@NonNull String column, double value) {
        Preconditions.argumentNotNull(column, "Column is required");
        this.getCurrent().put(column, Double.valueOf(value));
    }

    void set(@NonNull String column, boolean value) {
        Preconditions.argumentNotNull(column, "Column is required");
        this.getCurrent().put(column, Boolean.valueOf(value));
    }

    void set(@NonNull String column, @NonNull String value) {
        Preconditions.argumentNotNull(column, "Column is required");
        Preconditions.argumentNotNull(value, "Value is required. If you need to set null, use the setNull() method");
        this.getCurrent().put(column, value);
    }

    void set(@NonNull String column, byte[] value) {
        Preconditions.argumentNotNull(column, "Column is required");
        Preconditions.argumentNotNull(value, "Value is required. If you need to set null, use the setNull() method");
        this.getCurrent().put(column, value);
    }

    ContentValues getSingleValue() {
        Preconditions.stateCondition(this.mContentValues.size() != 1, "Invalid value count. Expected 1, found " + this.mContentValues.size());
        return this.mContentValues.get(0);
    }

    ContentValues[] getValuesAsArray() {
        return this.mContentValues.toArray(new ContentValues[this.mContentValues.size()]);
    }
}

