/*
 * Decompiled with CFR 0.152.
 */
package bg.dalexiev.bender.content;

import android.content.ContentResolver;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import bg.dalexiev.bender.content.BaseResolverCommand;
import bg.dalexiev.bender.content.ContentValuesBuilder;

public class BulkInsertCommand
extends BaseResolverCommand<Integer, Callback, BulkInsertCommand> {
    private final ContentValuesBuilder mContentValuesBuilder;

    BulkInsertCommand(ContentResolver contentResolver) {
        super(contentResolver);
        this.mContentValuesBuilder = new ContentValuesBuilder();
    }

    @VisibleForTesting
    BulkInsertCommand(BaseResolverCommand.WorkerHandler workerHandler, ContentResolver contentResolver, ContentValuesBuilder contentValuesBuilder) {
        super(workerHandler, contentResolver);
        this.mContentValuesBuilder = contentValuesBuilder;
    }

    @NonNull
    public BulkInsertCommand setNull(@NonNull String column) {
        this.mContentValuesBuilder.setNull(column);
        return this;
    }

    @NonNull
    public BulkInsertCommand set(@NonNull String column, byte value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public BulkInsertCommand set(@NonNull String column, short value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public BulkInsertCommand set(@NonNull String column, int value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public BulkInsertCommand set(@NonNull String column, long value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public BulkInsertCommand set(@NonNull String column, float value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public BulkInsertCommand set(@NonNull String column, double value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public BulkInsertCommand set(@NonNull String column, boolean value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public BulkInsertCommand set(@NonNull String column, @NonNull String value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public BulkInsertCommand set(@NonNull String column, byte[] value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public BulkInsertCommand newRow() {
        this.mContentValuesBuilder.newValue();
        return this;
    }

    @Override
    protected Integer executeResolverCommand(@NonNull ContentResolver contentResolver) {
        return contentResolver.bulkInsert(this.getUri(), this.mContentValuesBuilder.getValuesAsArray());
    }

    @Override
    protected void notifyCallback(@NonNull Callback callback, int token, @Nullable Integer result) {
        callback.onBulkInsertComplete(token, result);
    }

    public static interface Callback
    extends BaseResolverCommand.Callback {
        public void onBulkInsertComplete(int var1, int var2);
    }
}

