/*
 * Decompiled with CFR 0.152.
 */
package bg.dalexiev.bender.content;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import bg.dalexiev.bender.util.Preconditions;
import java.lang.ref.WeakReference;

abstract class BaseResolverCommand<T, C extends Callback, RC extends BaseResolverCommand<T, C, RC>>
implements Handler.Callback {
    private static Looper sLooper;
    private final WeakReference<ContentResolver> mResolverRef;
    private WeakReference<C> mCallbackRef;
    private final WorkerHandler mWorkerHandler;
    private Uri mUri;
    private int mToken;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseResolverCommand(@NonNull ContentResolver contentResolver) {
        Preconditions.argumentNotNull(contentResolver, "ContentResolver can't be null");
        Class<BaseResolverCommand> clazz = BaseResolverCommand.class;
        synchronized (BaseResolverCommand.class) {
            if (sLooper == null) {
                HandlerThread workerThread = new HandlerThread("ResolverCommandWorker");
                workerThread.start();
                sLooper = workerThread.getLooper();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.mWorkerHandler = new WorkerHandler(sLooper, this);
            this.mResolverRef = new WeakReference<ContentResolver>(contentResolver);
            return;
        }
    }

    @VisibleForTesting
    BaseResolverCommand(WorkerHandler workerHandler, ContentResolver resolver) {
        this.mWorkerHandler = workerHandler;
        this.mResolverRef = new WeakReference<ContentResolver>(resolver);
    }

    @NonNull
    public RC onUri(@NonNull Uri uri) {
        Preconditions.argumentNotNull(uri, "Uri can't be null");
        this.mUri = uri;
        return (RC)this;
    }

    @Nullable
    public T execute() {
        this.validateStatePreExecute();
        ContentResolver contentResolver = (ContentResolver)this.mResolverRef.get();
        if (contentResolver == null) {
            return null;
        }
        return this.executeResolverCommand(contentResolver);
    }

    public void executeAsync(int token, @Nullable C callback) {
        this.validateStatePreExecute();
        this.mToken = token;
        if (callback != null) {
            this.mCallbackRef = new WeakReference<C>(callback);
        }
        Message message = this.mWorkerHandler.obtainMessage(token, new Handler((Handler.Callback)this));
        message.sendToTarget();
    }

    public void cancel() {
        this.mWorkerHandler.removeMessages(this.mToken);
    }

    @Nullable
    protected Uri getUri() {
        return this.mUri;
    }

    @CallSuper
    protected void validateStatePreExecute() {
        Preconditions.stateNotNull(this.mUri, "Uri not set. Did you call onUri()?");
    }

    @Nullable
    protected abstract T executeResolverCommand(@NonNull ContentResolver var1);

    public boolean handleMessage(Message msg) {
        if (this.mCallbackRef == null) {
            return true;
        }
        Callback callback = (Callback)this.mCallbackRef.get();
        if (callback == null) {
            return true;
        }
        this.notifyCallback(callback, msg.what, msg.obj);
        return true;
    }

    protected abstract void notifyCallback(@NonNull C var1, int var2, @Nullable T var3);

    protected static interface Callback {
    }

    @VisibleForTesting
    static class WorkerHandler<T>
    extends Handler {
        private final WeakReference<BaseResolverCommand<T, ?, ?>> mCommandRef;

        WorkerHandler(Looper looper, BaseResolverCommand<T, ?, ?> command) {
            super(looper);
            this.mCommandRef = new WeakReference(command);
        }

        public void handleMessage(Message msg) {
            BaseResolverCommand command = (BaseResolverCommand)this.mCommandRef.get();
            if (command == null) {
                return;
            }
            ContentResolver contentResolver = (ContentResolver)command.mResolverRef.get();
            if (contentResolver == null) {
                return;
            }
            Object result = command.executeResolverCommand(contentResolver);
            int what = msg.what;
            Handler callback = (Handler)msg.obj;
            Message callbackMessage = callback.obtainMessage(what, result);
            callbackMessage.sendToTarget();
        }
    }
}

