/*
 * Decompiled with CFR 0.152.
 */
package bg.dalexiev.bender.util;

public final class Preconditions {
    private Preconditions() {
    }

    public static <R> void notNull(R reference, String message) {
        Preconditions.notNull(reference, new NullPointerException(message));
    }

    public static <R> void stateNotNull(R reference, String message) {
        Preconditions.notNull(reference, new IllegalStateException(message));
    }

    public static <R> void argumentNotNull(R reference, String message) {
        Preconditions.notNull(reference, new IllegalArgumentException(message));
    }

    public static void stateCondition(boolean condition, String message) {
        Preconditions.condition(condition, new IllegalStateException(message));
    }

    public static void argumentCondition(boolean condition, String message) {
        Preconditions.condition(condition, new IllegalArgumentException(message));
    }

    private static <R> void notNull(R reference, RuntimeException exception) {
        if (reference == null) {
            throw exception;
        }
    }

    private static void condition(boolean condition, RuntimeException exception) {
        if (condition) {
            throw exception;
        }
    }
}

