/*
 * Decompiled with CFR 0.152.
 */
package bg.dalexiev.bender.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import bg.dalexiev.bender.db.OrderBy;
import bg.dalexiev.bender.db.Predicate;
import bg.dalexiev.bender.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SqlSelectionBuilder {
    private static final String AND = " and ";
    private static final String OR = " or ";
    private static final String SEPARATOR_COMMA = ", ";
    private String mTable;
    private boolean mIsDistinct;
    private final StringBuilder mSelection = new StringBuilder();
    private final List<String> mSelectionArgs = new ArrayList<String>(10);
    private String mGroupBy;
    private String mHaving;
    private final StringBuilder mOrderBy = new StringBuilder();
    private String mLimit;

    @NonNull
    public SqlSelectionBuilder setTable(@NonNull String table) {
        Preconditions.argumentNotNull(table, "Table name can't be null");
        this.mTable = table;
        return this;
    }

    @NonNull
    public SqlSelectionBuilder setDistinct() {
        this.mIsDistinct = true;
        return this;
    }

    @NonNull
    public SqlSelectionBuilder where(@Nullable String selection, String ... args) {
        SqlSelectionBuilder.appendWhere(this.mSelection, this.mSelectionArgs, selection, args, AND);
        return this;
    }

    @NonNull
    public SqlSelectionBuilder where(@NonNull Predicate predicate) {
        Preconditions.argumentNotNull(predicate, "Predicate can't be null");
        SqlSelectionBuilder.appendWhere(this.mSelection, this.mSelectionArgs, predicate.getExpression(), predicate.getArguments(), AND);
        return this;
    }

    @NonNull
    public SqlSelectionBuilder orWhere(@Nullable String selection, String ... args) {
        SqlSelectionBuilder.appendWhere(this.mSelection, this.mSelectionArgs, selection, args, OR);
        return this;
    }

    @NonNull
    public SqlSelectionBuilder orWhere(@NonNull Predicate predicate) {
        Preconditions.argumentNotNull(predicate, "Predicate can't be null");
        SqlSelectionBuilder.appendWhere(this.mSelection, this.mSelectionArgs, predicate.getExpression(), predicate.getArguments(), OR);
        return this;
    }

    private static void appendWhere(@NonNull StringBuilder selectionBuilder, List<String> selectionArgs, @Nullable String selection, @Nullable String[] args, @NonNull String logicalOperator) {
        if (selection == null) {
            return;
        }
        SqlSelectionBuilder.appendWhereClause(selectionBuilder, selection, logicalOperator);
        SqlSelectionBuilder.appendArgs(selectionArgs, args);
    }

    private static void appendWhereClause(@NonNull StringBuilder selectionBuilder, @NonNull String selection, @NonNull String logicalOperator) {
        if (selectionBuilder.length() > 0) {
            selectionBuilder.append(logicalOperator);
        }
        selectionBuilder.append('(').append(selection).append(')');
    }

    private static void appendArgs(@NonNull List<String> selectionArgs, @Nullable String[] args) {
        if (args != null) {
            Collections.addAll(selectionArgs, args);
        }
    }

    @NonNull
    public SqlSelectionBuilder groupBy(String ... columns) {
        if (columns == null) {
            return this;
        }
        int length = columns.length;
        if (length == 0) {
            return this;
        }
        StringBuilder groupByBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            groupByBuilder.append(columns[i]);
            if (i == length - 1) continue;
            groupByBuilder.append(SEPARATOR_COMMA);
        }
        this.mGroupBy = groupByBuilder.toString();
        return this;
    }

    @NonNull
    public SqlSelectionBuilder having(@Nullable String having) {
        this.mHaving = having;
        return this;
    }

    @NonNull
    public SqlSelectionBuilder orderBy(@Nullable String orderBy) {
        this.appendOrderBy(orderBy);
        return this;
    }

    @NonNull
    public SqlSelectionBuilder orderBy(OrderBy ... orderBy) {
        Preconditions.argumentNotNull(orderBy, "OrderBy can't be null");
        Preconditions.argumentCondition(orderBy.length == 0, "OrderBy can't be empty");
        for (OrderBy order : orderBy) {
            this.appendOrderBy(order.getExpression());
        }
        return this;
    }

    private void appendOrderBy(@Nullable String orderBy) {
        if (orderBy == null) {
            return;
        }
        if (this.mOrderBy.length() > 0) {
            this.mOrderBy.append(SEPARATOR_COMMA);
        }
        this.mOrderBy.append(orderBy);
    }

    @NonNull
    public SqlSelectionBuilder limit(@NonNull String limit) {
        Preconditions.argumentNotNull(limit, "Limit can't be null");
        this.mLimit = limit;
        return this;
    }

    public int update(@NonNull SQLiteDatabase db, @NonNull ContentValues values) {
        Preconditions.argumentNotNull(db, "Database can't be null");
        Preconditions.argumentNotNull(values, "Update values can't be null");
        Preconditions.argumentCondition(values.size() == 0, "Update values can't be empty");
        Preconditions.stateNotNull(this.mTable, "Can't execute an update with no table set. Did you call setTable()?");
        return db.update(this.mTable, values, this.getSelection(), this.getSelectionArgs());
    }

    public int delete(@NonNull SQLiteDatabase db) {
        Preconditions.argumentNotNull(db, "Database can't be null");
        Preconditions.stateNotNull(this.mTable, "Can't execute a delete with no table set. Did you call setTable()?");
        return db.delete(this.mTable, this.getSelection(), this.getSelectionArgs());
    }

    @Nullable
    public Cursor query(@NonNull SQLiteDatabase db, @Nullable String[] projection) {
        Preconditions.argumentNotNull(db, "Database can't be null");
        Preconditions.stateNotNull(this.mTable, "Can't execute a query with no table set. Did you call setTable()?");
        return db.query(this.mIsDistinct, this.mTable, projection, this.getSelection(), this.getSelectionArgs(), this.mGroupBy, this.mHaving, this.getOrderBy(), this.mLimit);
    }

    @Nullable
    public String[] getSelectionArgs() {
        if (this.mSelectionArgs.isEmpty()) {
            return null;
        }
        return this.mSelectionArgs.toArray(new String[this.mSelectionArgs.size()]);
    }

    @Nullable
    public String getTable() {
        return this.mTable;
    }

    public boolean isDistinct() {
        return this.mIsDistinct;
    }

    @Nullable
    public String getSelection() {
        if (this.mSelection.length() == 0) {
            return null;
        }
        return this.mSelection.toString();
    }

    @Nullable
    public String getGroupBy() {
        return this.mGroupBy;
    }

    @Nullable
    public String getHaving() {
        return this.mHaving;
    }

    @Nullable
    public String getOrderBy() {
        if (this.mOrderBy.length() == 0) {
            return null;
        }
        return this.mOrderBy.toString();
    }

    @Nullable
    public String getLimit() {
        return this.mLimit;
    }
}

