/*
 * Decompiled with CFR 0.152.
 */
package bg.dalexiev.bender.db;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.support.annotation.NonNull;
import bg.dalexiev.bender.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class SqlInsertionBuilder {
    private static final String SQL_TEMPLATE = "insert into %s(%s) values (%s)";
    private String mTable;
    private List<ContentValues> mContentValues;

    @NonNull
    public SqlInsertionBuilder setTable(@NonNull String table) {
        Preconditions.argumentNotNull(table, "Table can't be null");
        this.mTable = table;
        return this;
    }

    @NonNull
    public SqlInsertionBuilder appendValues(ContentValues ... values) {
        Preconditions.argumentNotNull(values, "Values can't be null");
        Preconditions.argumentCondition(values.length == 0, "Values can't be empty");
        if (this.mContentValues == null) {
            this.mContentValues = new ArrayList<ContentValues>();
        }
        Collections.addAll(this.mContentValues, values);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> insert(@NonNull SQLiteDatabase db) {
        Preconditions.argumentNotNull(db, "Database can't be null");
        Preconditions.stateNotNull(this.mTable, "Can't execute an insert with no table set. Did you call setTable()?");
        String sql = this.generateSql();
        LinkedList<Long> generatedIds = new LinkedList<Long>();
        try (SQLiteStatement statement = db.compileStatement(sql);){
            this.executeInsertStatement(statement, generatedIds);
        }
        return generatedIds;
    }

    private void executeInsertStatement(SQLiteStatement statement, List<Long> generatedIds) {
        for (ContentValues values : this.mContentValues) {
            statement.clearBindings();
            SqlInsertionBuilder.bindValues(statement, values);
            generatedIds.add(statement.executeInsert());
        }
    }

    String generateSql() {
        Set columnNames = null;
        ContentValues contentValues = this.mContentValues.get(0);
        columnNames = contentValues == null ? Collections.singleton("_id") : contentValues.keySet();
        String columns = SqlInsertionBuilder.generateColumns(columnNames);
        String values = SqlInsertionBuilder.generateValues(columnNames.size());
        return String.format((Locale)null, SQL_TEMPLATE, this.mTable, columns, values);
    }

    private static String generateColumns(Set<String> columnNames) {
        StringBuilder columnBuilder = new StringBuilder();
        for (String columnName : columnNames) {
            columnBuilder.append(columnName);
            columnBuilder.append(", ");
        }
        return columnBuilder.substring(0, columnBuilder.length() - 2);
    }

    private static String generateValues(int size) {
        StringBuilder valueBuilder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            valueBuilder.append("?, ");
        }
        return valueBuilder.substring(0, valueBuilder.length() - 2);
    }

    private static void bindValues(SQLiteStatement statement, ContentValues contentValues) {
        if (contentValues == null) {
            return;
        }
        int parameterIndex = 1;
        for (String column : contentValues.keySet()) {
            String value = contentValues.getAsString(column);
            if (value == null) {
                statement.bindNull(parameterIndex);
            } else {
                statement.bindString(parameterIndex, value);
            }
            ++parameterIndex;
        }
    }
}

