/*
 * Decompiled with CFR 0.152.
 */
package bg.dalexiev.bender.db;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import bg.dalexiev.bender.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Predicate {
    private static final String OPERATOR_EQ = "=";
    private static final String OPERATOR_NOT_EQ = "<>";
    private static final String OPERATOR_GT = ">";
    private static final String OPERATOR_GE = ">=";
    private static final String OPERATOR_LT = "<";
    private static final String OPERATOR_LE = "<=";
    private static final String OPERATOR_LIKE = "like";
    private static final String OPERATOR_IS_NULL = "is null";
    private static final String OPERATOR_IS_NOT_NULL = "is not null";
    private static final String OPERATOR_BETWEEN = "between";
    private static final String OPERATOR_IN = "in";
    private static final char WILDCARD_PARAMETER = '?';
    private final StringBuilder mExpression;
    private final List<String> mArguments;

    private Predicate(@NonNull StringBuilder expression, String ... arguments) {
        this.mExpression = expression;
        this.mArguments = new ArrayList<String>(5);
        if (arguments != null) {
            Collections.addAll(this.mArguments, arguments);
        }
    }

    @NonNull
    public Predicate and(@NonNull Predicate predicate) {
        this.appendPredicate(predicate, " and ");
        return this;
    }

    @NonNull
    public Predicate or(@NonNull Predicate predicate) {
        this.appendPredicate(predicate, " or ");
        return this;
    }

    private void appendPredicate(@NonNull Predicate predicate, @NonNull String logicalOperator) {
        Preconditions.argumentNotNull(predicate, "Predicate can't be null");
        this.mExpression.append(logicalOperator).append((CharSequence)predicate.mExpression);
        this.mArguments.addAll(predicate.mArguments);
    }

    @NonNull
    String getExpression() {
        return this.mExpression.toString();
    }

    @Nullable
    String[] getArguments() {
        if (this.mArguments == null) {
            return null;
        }
        return this.mArguments.toArray(new String[this.mArguments.size()]);
    }

    @NonNull
    public static Predicate eq(@NonNull String column, @NonNull String value) {
        Predicate.validateColumnAndValue(column, value);
        return new Predicate(Predicate.buildUnaryExpression(column, OPERATOR_EQ), value);
    }

    @NonNull
    public static Predicate notEq(@NonNull String column, @NonNull String value) {
        Predicate.validateColumnAndValue(column, value);
        return new Predicate(Predicate.buildUnaryExpression(column, OPERATOR_NOT_EQ), value);
    }

    @NonNull
    public static Predicate gt(@NonNull String column, @NonNull String value) {
        Predicate.validateColumnAndValue(column, value);
        return new Predicate(Predicate.buildUnaryExpression(column, OPERATOR_GT), value);
    }

    @NonNull
    public static Predicate ge(@NonNull String column, @NonNull String value) {
        Predicate.validateColumnAndValue(column, value);
        return new Predicate(Predicate.buildUnaryExpression(column, OPERATOR_GE), value);
    }

    @NonNull
    public static Predicate lt(@NonNull String column, @NonNull String value) {
        Predicate.validateColumnAndValue(column, value);
        return new Predicate(Predicate.buildUnaryExpression(column, OPERATOR_LT), value);
    }

    @NonNull
    public static Predicate le(@NonNull String column, @NonNull String value) {
        Predicate.validateColumnAndValue(column, value);
        return new Predicate(Predicate.buildUnaryExpression(column, OPERATOR_LE), value);
    }

    @NonNull
    public static Predicate like(@NonNull String column, @NonNull String value) {
        Predicate.validateColumnAndValue(column, value);
        return new Predicate(Predicate.buildUnaryExpression(column, OPERATOR_LIKE), value);
    }

    @NonNull
    public static Predicate isNull(@NonNull String column) {
        Preconditions.argumentNotNull(column, "Column can't be null");
        return new Predicate(Predicate.buildBaseExpression(column, OPERATOR_IS_NULL), null);
    }

    @NonNull
    public static Predicate isNotNull(@NonNull String column) {
        Preconditions.argumentNotNull(column, "Column can't be null");
        return new Predicate(Predicate.buildBaseExpression(column, OPERATOR_IS_NOT_NULL), null);
    }

    @NonNull
    public static Predicate between(@NonNull String column, @NonNull String start, @NonNull String end) {
        Preconditions.argumentNotNull(column, "Column can't be null");
        Preconditions.argumentNotNull(start, "Start can't be null");
        Preconditions.argumentNotNull(end, "End can't be null");
        return new Predicate(Predicate.buildBetweenExpression(column), start, end);
    }

    @NonNull
    public static Predicate in(@NonNull String column, String ... values) {
        Preconditions.argumentNotNull(column, "Column can't be null");
        Preconditions.argumentNotNull(values, "Arguments can't be null");
        Preconditions.argumentCondition(values.length == 0, "Arguments can't be empty");
        return new Predicate(Predicate.buildInExpression(column, values.length), values);
    }

    private static void validateColumnAndValue(String column, String value) {
        Preconditions.argumentNotNull(column, "Column can't be null");
        Preconditions.argumentNotNull(value, "Value can't be null");
    }

    @NonNull
    private static StringBuilder buildUnaryExpression(@NonNull String column, @NonNull String operator) {
        return Predicate.buildBaseExpression(column, operator).append(' ').append('?');
    }

    @NonNull
    private static StringBuilder buildBetweenExpression(@NonNull String column) {
        return Predicate.buildBaseExpression(column, OPERATOR_BETWEEN).append(" ? and ?");
    }

    @NonNull
    private static StringBuilder buildInExpression(@NonNull String column, int parameterCount) {
        if (parameterCount == 1) {
            return Predicate.buildUnaryExpression(column, OPERATOR_EQ);
        }
        StringBuilder expressionBuilder = Predicate.buildBaseExpression(column, OPERATOR_IN).append(" (");
        for (int i = 0; i < parameterCount; ++i) {
            expressionBuilder.append('?');
            if (i == parameterCount - 1) continue;
            expressionBuilder.append(", ");
        }
        expressionBuilder.append(')');
        return expressionBuilder;
    }

    @NonNull
    private static StringBuilder buildBaseExpression(@NonNull String column, @NonNull String operator) {
        StringBuilder expressionBuilder = new StringBuilder();
        expressionBuilder.append(column).append(' ').append(operator);
        return expressionBuilder;
    }
}

