/*
 * Decompiled with CFR 0.152.
 */
package bg.dalexiev.bender.content;

import android.content.ContentResolver;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import bg.dalexiev.bender.content.BaseResolverCommand;
import bg.dalexiev.bender.content.ContentValuesBuilder;
import bg.dalexiev.bender.db.Predicate;
import bg.dalexiev.bender.db.SqlSelectionBuilder;
import bg.dalexiev.bender.util.Preconditions;

public class UpdateCommand
extends BaseResolverCommand<Integer, Callback, UpdateCommand> {
    private final ContentValuesBuilder mContentValuesBuilder;
    private final SqlSelectionBuilder mSelectionBuilder;

    UpdateCommand(ContentResolver contentResolver) {
        super(contentResolver);
        this.mContentValuesBuilder = new ContentValuesBuilder();
        this.mSelectionBuilder = new SqlSelectionBuilder();
    }

    UpdateCommand(BaseResolverCommand.WorkerHandler workerHandler, ContentResolver contentResolver, ContentValuesBuilder contentValuesBuilder, SqlSelectionBuilder selectionBuilder) {
        super(workerHandler, contentResolver);
        this.mContentValuesBuilder = contentValuesBuilder;
        this.mSelectionBuilder = selectionBuilder;
    }

    @NonNull
    public UpdateCommand setNull(@NonNull String column) {
        this.mContentValuesBuilder.setNull(column);
        return this;
    }

    @NonNull
    public UpdateCommand set(@NonNull String column, byte value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public UpdateCommand set(@NonNull String column, short value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public UpdateCommand set(@NonNull String column, int value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public UpdateCommand set(@NonNull String column, long value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public UpdateCommand set(@NonNull String column, float value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public UpdateCommand set(@NonNull String column, double value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public UpdateCommand set(@NonNull String column, boolean value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public UpdateCommand set(@NonNull String column, @NonNull String value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public UpdateCommand set(@NonNull String column, byte[] value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public UpdateCommand where(@NonNull String selection, String[] selectionArgs) {
        Preconditions.argumentNotNull(selection, "Selection can't be null");
        this.mSelectionBuilder.where(selection, selectionArgs);
        return this;
    }

    @NonNull
    public UpdateCommand where(@NonNull Predicate predicate) {
        this.mSelectionBuilder.where(predicate);
        return this;
    }

    @NonNull
    public UpdateCommand orWhere(@NonNull String selection, @Nullable String[] selectionArgs) {
        Preconditions.argumentNotNull(selection, "Selection can't be null");
        this.mSelectionBuilder.orWhere(selection, selectionArgs);
        return this;
    }

    @NonNull
    public UpdateCommand orWhere(@NonNull Predicate predicate) {
        this.mSelectionBuilder.orWhere(predicate);
        return this;
    }

    @Override
    protected void validateStatePreExecute() {
        super.validateStatePreExecute();
        Preconditions.stateNotNull(this.mContentValuesBuilder, "No values to update. Did you call forEntity() or any of the set...() methods?");
    }

    @Override
    protected Integer executeResolverCommand(@NonNull ContentResolver contentResolver) {
        Uri uri = this.getUri();
        return contentResolver.update(uri, this.mContentValuesBuilder.getSingleValue(), this.mSelectionBuilder.getSelection(), this.mSelectionBuilder.getSelectionArgs());
    }

    @Override
    protected void notifyCallback(@NonNull Callback callback, int token, Integer result) {
        callback.onUpdateComplete(token, result);
    }

    public static interface Callback
    extends BaseResolverCommand.Callback {
        public void onUpdateComplete(int var1, int var2);
    }
}

