/*
 * Decompiled with CFR 0.152.
 */
package bg.dalexiev.bender.content;

import android.content.ContentResolver;
import android.database.Cursor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import bg.dalexiev.bender.content.BaseResolverCommand;
import bg.dalexiev.bender.content.DefaultCursorMapper;
import bg.dalexiev.bender.content.EntityCursor;
import bg.dalexiev.bender.db.OrderBy;
import bg.dalexiev.bender.db.Predicate;
import bg.dalexiev.bender.db.SqlSelectionBuilder;
import bg.dalexiev.bender.mapper.CursorMapper;
import bg.dalexiev.bender.mapper.RowMapper;
import bg.dalexiev.bender.util.Preconditions;

public class QueryCommand<R>
extends BaseResolverCommand<EntityCursor<R>, Callback<R>, QueryCommand<R>> {
    private String[] mProjection;
    private final SqlSelectionBuilder mSelectionBuilder;
    private CursorMapper<R> mCursorMapper;

    QueryCommand(ContentResolver contentResolver) {
        super(contentResolver);
        this.mSelectionBuilder = new SqlSelectionBuilder();
    }

    QueryCommand(BaseResolverCommand.WorkerHandler workerHandler, ContentResolver contentResolver, SqlSelectionBuilder selectionBuilder) {
        super(workerHandler, contentResolver);
        this.mSelectionBuilder = selectionBuilder;
    }

    @NonNull
    public QueryCommand<R> select(String ... columns) {
        Preconditions.argumentNotNull(columns, "Projection can't be null");
        Preconditions.argumentCondition(columns.length == 0, "Projection can't be empty");
        this.mProjection = columns;
        return this;
    }

    @NonNull
    public QueryCommand<R> where(@NonNull String selection, @Nullable String[] selectionArgs) {
        Preconditions.argumentNotNull(selection, "Selection can't be null");
        this.mSelectionBuilder.where(selection, selectionArgs);
        return this;
    }

    @NonNull
    public QueryCommand<R> where(@NonNull Predicate predicate) {
        this.mSelectionBuilder.where(predicate);
        return this;
    }

    @NonNull
    public QueryCommand orWhere(@NonNull String selection, @Nullable String[] selectionArgs) {
        Preconditions.argumentNotNull(selection, "Selection can't be null");
        this.mSelectionBuilder.orWhere(selection, selectionArgs);
        return this;
    }

    @NonNull
    public QueryCommand<R> orWhere(@NonNull Predicate predicate) {
        this.mSelectionBuilder.orWhere(predicate);
        return this;
    }

    @NonNull
    public QueryCommand<R> orderBy(@NonNull String orderBy) {
        Preconditions.argumentNotNull(orderBy, "Order by is required");
        this.mSelectionBuilder.orderBy(orderBy);
        return this;
    }

    public QueryCommand<R> orderBy(OrderBy ... orderBy) {
        this.mSelectionBuilder.orderBy(orderBy);
        return this;
    }

    @NonNull
    public QueryCommand<R> useRowMapper(@NonNull RowMapper<R> rowMapper) {
        Preconditions.stateCondition(this.mCursorMapper != null, "A mapper has already been set");
        Preconditions.argumentNotNull(rowMapper, "Row mapper is required");
        this.mCursorMapper = new DefaultCursorMapper<R>(rowMapper);
        return this;
    }

    public QueryCommand<R> useCursorMapper(@NonNull CursorMapper<R> cursorMapper) {
        Preconditions.stateCondition(this.mCursorMapper != null, "A mapper has already been set");
        Preconditions.argumentNotNull(cursorMapper, "Cursor mapper is required");
        this.mCursorMapper = cursorMapper;
        return this;
    }

    @Override
    protected void validateStatePreExecute() {
        super.validateStatePreExecute();
        Preconditions.stateNotNull(this.mProjection, "No projection has been set. Did you call setProjection()?");
        Preconditions.stateNotNull(this.mCursorMapper, "No mapper has been set. Did you call setRowMapper() or setCursorMapper()?");
    }

    @Override
    @Nullable
    protected EntityCursor<R> executeResolverCommand(@NonNull ContentResolver contentResolver) {
        Cursor cursor = contentResolver.query(this.getUri(), this.mProjection, this.mSelectionBuilder.getSelection(), this.mSelectionBuilder.getSelectionArgs(), this.mSelectionBuilder.getOrderBy());
        if (cursor == null) {
            return null;
        }
        EntityCursor<R> entityCursor = new EntityCursor<R>(cursor, this.mCursorMapper);
        entityCursor.mapCursor();
        return entityCursor;
    }

    @Override
    protected void notifyCallback(@NonNull Callback<R> callback, int token, EntityCursor<R> result) {
        callback.onQueryComplete(token, result);
    }

    public static interface Callback<E>
    extends BaseResolverCommand.Callback {
        public void onQueryComplete(int var1, EntityCursor<E> var2);
    }
}

