/*
 * Decompiled with CFR 0.152.
 */
package bg.dalexiev.bender.content;

import android.content.ContentResolver;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import bg.dalexiev.bender.content.BaseResolverCommand;
import bg.dalexiev.bender.content.ContentValuesBuilder;
import bg.dalexiev.bender.util.Preconditions;

public class InsertCommand
extends BaseResolverCommand<Uri, Callback, InsertCommand> {
    private final ContentValuesBuilder mContentValuesBuilder;

    InsertCommand(ContentResolver contentResolver) {
        super(contentResolver);
        this.mContentValuesBuilder = new ContentValuesBuilder();
    }

    InsertCommand(BaseResolverCommand.WorkerHandler workerHandler, ContentResolver callbackHandler, ContentValuesBuilder contentValuesBuilder) {
        super(workerHandler, callbackHandler);
        this.mContentValuesBuilder = contentValuesBuilder;
    }

    @Override
    protected void validateStatePreExecute() {
        super.validateStatePreExecute();
        Preconditions.stateNotNull(this.mContentValuesBuilder, "Entities and row mapper not set. Did you call forEntity() or forEntities()?");
    }

    @NonNull
    public InsertCommand setNull(@NonNull String column) {
        this.mContentValuesBuilder.setNull(column);
        return this;
    }

    @NonNull
    public InsertCommand set(@NonNull String column, byte value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public InsertCommand set(@NonNull String column, short value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public InsertCommand set(@NonNull String column, int value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public InsertCommand set(@NonNull String column, long value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public InsertCommand set(@NonNull String column, float value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public InsertCommand set(@NonNull String column, double value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public InsertCommand set(@NonNull String column, boolean value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public InsertCommand set(@NonNull String column, @NonNull String value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @NonNull
    public InsertCommand set(@NonNull String column, byte[] value) {
        this.mContentValuesBuilder.set(column, value);
        return this;
    }

    @Override
    @Nullable
    protected Uri executeResolverCommand(@NonNull ContentResolver contentResolver) {
        Uri insertUri = this.getUri();
        return contentResolver.insert(insertUri, this.mContentValuesBuilder.getSingleValue());
    }

    @Override
    protected void notifyCallback(@NonNull Callback callback, int token, Uri result) {
        callback.onInsertComplete(token, result);
    }

    public static interface Callback
    extends BaseResolverCommand.Callback {
        public void onInsertComplete(int var1, Uri var2);
    }
}

