/*
 * Decompiled with CFR 0.152.
 */
package bg.dalexiev.bender.content;

import android.database.Cursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWrapper;
import android.util.SparseArray;
import bg.dalexiev.bender.content.DefaultCursorMapper;
import bg.dalexiev.bender.mapper.CursorMapper;
import bg.dalexiev.bender.mapper.RowMapper;

public class EntityCursor<E>
extends CursorWrapper {
    private final CursorMapper<E> mCursorMapper;
    private SparseArray<E> mCache;
    private int mPosition;

    EntityCursor(Cursor cursor, CursorMapper<E> cursorMapper) {
        super(cursor);
        this.mCursorMapper = cursorMapper;
    }

    EntityCursor(Cursor cursor, RowMapper<E> rowMapper) {
        this(cursor, new DefaultCursorMapper<E>(rowMapper));
    }

    final void mapCursor() {
        Cursor cursor = this.getWrappedCursor();
        if (cursor == null || cursor.getCount() == 0) {
            return;
        }
        this.mCache = this.mCursorMapper.mapCursor(cursor);
        cursor.moveToPosition(0);
    }

    public E getEntity() {
        if (-1 >= this.mPosition || this.getCount() <= this.mPosition) {
            throw new CursorIndexOutOfBoundsException("Invalid cursor position " + this.mPosition);
        }
        Object entity = this.mCache.get(this.mPosition);
        return (E)entity;
    }

    public int getCount() {
        if (this.mCache == null) {
            return 0;
        }
        return this.mCache.size();
    }

    public int getPosition() {
        return this.mPosition;
    }

    public boolean move(int offset) {
        int newPosition = this.mPosition + offset;
        if (newPosition > this.getCount()) {
            this.mPosition = this.getCount();
            return false;
        }
        if (-1 > newPosition) {
            this.mPosition = -1;
            return false;
        }
        this.mPosition = newPosition;
        return true;
    }

    public boolean moveToPosition(int position) {
        if (-1 > position || this.getCount() < position) {
            return false;
        }
        this.mPosition = position;
        return true;
    }

    public boolean moveToNext() {
        return this.moveToPosition(this.mPosition + 1);
    }

    public boolean moveToPrevious() {
        return this.moveToPosition(this.mPosition - 1);
    }

    public boolean moveToLast() {
        return this.moveToPosition(this.getCount() - 1);
    }

    public boolean moveToFirst() {
        return this.moveToPosition(0);
    }

    public boolean isLast() {
        return this.mPosition == this.getCount() - 1;
    }

    public boolean isFirst() {
        return this.mPosition == 0;
    }

    public boolean isAfterLast() {
        return this.mPosition >= this.getCount();
    }

    public boolean isBeforeFirst() {
        return this.mPosition <= -1;
    }
}

