/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.MapLN;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DirtyINMap {
    private EnvironmentImpl envImpl;
    private SortedMap<Integer, Map<Long, Checkpointer.CheckpointReference>> levelMap;
    private int numEntries;
    private Set<DatabaseId> mapLNsToFlush;

    DirtyINMap(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
        this.levelMap = new TreeMap<Integer, Map<Long, Checkpointer.CheckpointReference>>();
        this.numEntries = 0;
        this.mapLNsToFlush = new HashSet<DatabaseId>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<DatabaseImpl, Integer> selectDirtyINsForCheckpoint(boolean flushAll, boolean flushExtraLevel) throws DatabaseException {
        DatabaseImpl db;
        IdentityHashMap<DatabaseImpl, Integer> highestLevelSeenMap = new IdentityHashMap<DatabaseImpl, Integer>();
        DbTree dbTree = this.envImpl.getDbTree();
        INList inMemINs = this.envImpl.getInMemoryINs();
        inMemINs.memRecalcBegin();
        boolean completed = false;
        try {
            for (IN iN : inMemINs) {
                iN.latch(CacheMode.UNCHANGED);
                db = iN.getDatabase();
                try {
                    inMemINs.memRecalcIterate(iN);
                    if (db.isTemporary()) continue;
                    Integer level = this.addDirtyIN(iN, false);
                    if (level != null) {
                        if (flushAll || db.isDurableDeferredWrite()) {
                            if (!highestLevelSeenMap.containsKey(db)) {
                                highestLevelSeenMap.put(db, null);
                            }
                        } else {
                            Integer highestLevelSeen;
                            int levelVal = level;
                            if (flushExtraLevel) {
                                if (iN.isRoot()) {
                                    if (!iN.isDbRoot()) {
                                        levelVal = 65537;
                                    }
                                } else {
                                    ++levelVal;
                                }
                            }
                            if ((highestLevelSeen = (Integer)highestLevelSeenMap.get(db)) == null || levelVal > highestLevelSeen) {
                                if (flushExtraLevel) {
                                    level = levelVal;
                                }
                                highestLevelSeenMap.put(db, level);
                            }
                        }
                    }
                    this.saveMapLNsToFlush(iN);
                }
                finally {
                    iN.releaseLatch();
                }
            }
            completed = true;
        }
        finally {
            inMemINs.memRecalcEnd(completed);
        }
        for (Map.Entry entry : highestLevelSeenMap.entrySet()) {
            if (entry.getValue() != null) continue;
            db = (DatabaseImpl)entry.getKey();
            entry.setValue(dbTree.getHighestLevel(db));
        }
        return highestLevelSeenMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<DatabaseImpl, Integer> selectDirtyINsForDbSync(DatabaseImpl dbImpl) throws DatabaseException {
        DatabaseId dbId = dbImpl.getId();
        for (IN in : this.envImpl.getInMemoryINs()) {
            if (!in.getDatabaseId().equals(dbId)) continue;
            in.latch(CacheMode.UNCHANGED);
            try {
                this.addDirtyIN(in, false);
            }
            finally {
                in.releaseLatch();
            }
        }
        IdentityHashMap<DatabaseImpl, Integer> highestFlushLevels = new IdentityHashMap<DatabaseImpl, Integer>();
        highestFlushLevels.put(dbImpl, this.envImpl.getDbTree().getHighestLevel(dbImpl));
        return highestFlushLevels;
    }

    int getNumLevels() {
        return this.levelMap.size();
    }

    void addCostToMemoryBudget() {
        MemoryBudget mb = this.envImpl.getMemoryBudget();
        int cost = this.numEntries * MemoryBudget.CHECKPOINT_REFERENCE_SIZE;
        mb.updateAdminMemoryUsage(cost);
    }

    void removeCostFromMemoryBudget() {
        MemoryBudget mb = this.envImpl.getMemoryBudget();
        int cost = this.numEntries * MemoryBudget.CHECKPOINT_REFERENCE_SIZE;
        mb.updateAdminMemoryUsage(0 - cost);
    }

    Integer addDirtyIN(IN in, boolean updateMemoryBudget) {
        if (in.getDirty()) {
            Map<Long, Checkpointer.CheckpointReference> nodeMap;
            Integer level = in.getLevel();
            if (this.levelMap.containsKey(level)) {
                nodeMap = (Map)this.levelMap.get(level);
            } else {
                nodeMap = new HashMap();
                this.levelMap.put(level, nodeMap);
            }
            nodeMap.put(in.getNodeId(), new Checkpointer.CheckpointReference(in.getDatabase().getId(), in.getNodeId(), in.containsDuplicates(), in.isDbRoot(), in.getMainTreeKey(), in.getDupTreeKey()));
            ++this.numEntries;
            if (updateMemoryBudget) {
                MemoryBudget mb = this.envImpl.getMemoryBudget();
                mb.updateAdminMemoryUsage(MemoryBudget.CHECKPOINT_REFERENCE_SIZE);
            }
            return level;
        }
        return null;
    }

    Integer getLowestLevelSet() {
        return this.levelMap.firstKey();
    }

    Iterator<Checkpointer.CheckpointReference> getIterator(Integer level) {
        return ((Map)this.levelMap.get(level)).values().iterator();
    }

    void removeLevel(Integer level) {
        this.levelMap.remove(level);
    }

    boolean containsNode(Integer level, Long nodeId) {
        Map nodeMap = (Map)this.levelMap.get(level);
        if (nodeMap != null) {
            return nodeMap.containsKey(nodeId);
        }
        return false;
    }

    Checkpointer.CheckpointReference removeNode(Integer level, Long nodeId) {
        Map nodeMap = (Map)this.levelMap.get(level);
        if (nodeMap != null) {
            return (Checkpointer.CheckpointReference)nodeMap.remove(nodeId);
        }
        return null;
    }

    Checkpointer.CheckpointReference removeNextNode(Integer level) {
        Iterator iter;
        Map nodeMap = (Map)this.levelMap.get(level);
        if (nodeMap != null && (iter = nodeMap.entrySet().iterator()).hasNext()) {
            Checkpointer.CheckpointReference ref = (Checkpointer.CheckpointReference)iter.next().getValue();
            iter.remove();
            return ref;
        }
        return null;
    }

    private void saveMapLNsToFlush(IN in) {
        if (in instanceof BIN && in.getDatabase().getId().equals(DbTree.ID_DB_ID)) {
            for (int i = 0; i < in.getNEntries(); ++i) {
                MapLN ln = (MapLN)in.getTarget(i);
                if (ln == null || !ln.getDatabase().isCheckpointNeeded()) continue;
                this.mapLNsToFlush.add(ln.getDatabase().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushMapLNs(long checkpointStart) throws DatabaseException {
        if (!this.mapLNsToFlush.isEmpty()) {
            DbTree dbTree = this.envImpl.getDbTree();
            for (DatabaseId dbId : this.mapLNsToFlush) {
                DatabaseImpl db = null;
                try {
                    db = dbTree.getDb(dbId);
                    if (db == null || db.isDeleted() || !db.isCheckpointNeeded()) continue;
                    dbTree.modifyDbRoot(db, checkpointStart, true);
                }
                finally {
                    dbTree.releaseDb(db);
                }
            }
            this.mapLNsToFlush.clear();
        }
    }

    void flushRoot(long checkpointStart) throws DatabaseException {
        DbTree dbTree = this.envImpl.getDbTree();
        if (dbTree.getDb(DbTree.ID_DB_ID).isCheckpointNeeded() || dbTree.getDb(DbTree.NAME_DB_ID).isCheckpointNeeded()) {
            this.envImpl.logMapTreeRoot(checkpointStart);
        }
    }
}

