/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

class VisitedObjects {
    static final int PRI_KEY_VISITED_OFFSET = 0x7FFFFFFE;
    static final int PROHIBIT_REF_OFFSET = 0x7FFFFFFD;
    static final Object PROHIBIT_REF_OBJECT = new Object();
    static final String PROHIBIT_NESTED_REF_MSG = "Cannot embed a reference to a proxied object in the proxy; for example, a collection may not be an element of the collection because collections are proxied";
    private static final int INIT_LEN = 50;
    private Object[] objects = new Object[50];
    private int[] offsets = new int[50];
    private int nextIndex = 0;

    VisitedObjects() {
    }

    int add(Object o, int offset) {
        int i = this.nextIndex++;
        if (this.nextIndex > this.objects.length) {
            this.growVisitedArrays();
        }
        this.objects[i] = o;
        this.offsets[i] = offset;
        return i;
    }

    void setObject(int index, Object o) {
        this.objects[index] = o;
    }

    void setOffset(int index, int offset) {
        this.offsets[index] = offset;
    }

    int getOffset(Object o) {
        for (int i = 0; i < this.nextIndex; ++i) {
            if (this.objects[i] != o) continue;
            return this.offsets[i];
        }
        return -1;
    }

    Object getObject(int offset) {
        for (int i = 0; i < this.nextIndex; ++i) {
            if (this.offsets[i] != offset) continue;
            return this.objects[i];
        }
        return null;
    }

    void replaceObject(Object existing, Object replacement) {
        for (int i = this.nextIndex - 1; i >= 0; --i) {
            if (this.objects[i] != existing) continue;
            this.objects[i] = replacement;
            return;
        }
        assert (false);
    }

    private void growVisitedArrays() {
        int oldLen = this.objects.length;
        int newLen = oldLen * 2;
        Object[] newObjects = new Object[newLen];
        int[] newOffsets = new int[newLen];
        System.arraycopy(this.objects, 0, newObjects, 0, oldLen);
        System.arraycopy(this.offsets, 0, newOffsets, 0, oldLen);
        this.objects = newObjects;
        this.offsets = newOffsets;
    }
}

