/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Accessor;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.ComplexFormat;
import com.sleepycat.persist.impl.Enhanced;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Format;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EnhancedAccessor
implements Accessor {
    private static final Map<String, Enhanced> classRegistry = Collections.synchronizedMap(new HashMap());
    public static final boolean EXPECT_ENHANCED = "true".equals(System.getProperty("expectEnhanced"));
    private Enhanced prototype;
    private Format priKeyFormat;
    private Class type;

    public static void registerClass(String className, Enhanced prototype) {
        classRegistry.put(className, prototype);
    }

    static boolean isEnhanced(Class type) {
        boolean enhanced = classRegistry.containsKey(type.getName());
        if (!enhanced && EXPECT_ENHANCED) {
            throw new IllegalStateException("Test was run with expectEnhanced=true but class " + type.getName() + " is not enhanced");
        }
        return enhanced;
    }

    EnhancedAccessor(Class type) {
        this.type = type;
        this.prototype = classRegistry.get(type.getName());
        assert (this.prototype != null || Modifier.isAbstract(type.getModifiers()));
    }

    EnhancedAccessor(Catalog catalog, Class type, ComplexFormat format) {
        this(type);
        ComplexFormat declaringFormat = format;
        while (declaringFormat != null) {
            String priKeyField = declaringFormat.getPriKeyField();
            if (priKeyField != null) {
                Class<?> fieldType;
                Class declaringType = declaringFormat.getType();
                try {
                    fieldType = declaringType.getDeclaredField(priKeyField).getType();
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalStateException(e);
                }
                this.priKeyFormat = catalog.getFormat(fieldType);
                break;
            }
            Format superFormat = declaringFormat.getSuperFormat();
            declaringFormat = (ComplexFormat)superFormat;
        }
    }

    public Object newInstance() {
        if (this.prototype == null) {
            throw new IllegalStateException();
        }
        return this.prototype.bdbNewInstance();
    }

    public Object newArray(int len) {
        if (this.prototype == null) {
            return Array.newInstance(this.type, len);
        }
        return this.prototype.bdbNewArray(len);
    }

    public boolean isPriKeyFieldNullOrZero(Object o) {
        if (this.priKeyFormat == null) {
            throw new IllegalStateException("No primary key: " + o.getClass().getName());
        }
        return ((Enhanced)o).bdbIsPriKeyFieldNullOrZero();
    }

    public void writePriKeyField(Object o, EntityOutput output) {
        if (this.priKeyFormat == null) {
            throw new IllegalStateException("No primary key: " + o.getClass().getName());
        }
        ((Enhanced)o).bdbWritePriKeyField(output, this.priKeyFormat);
    }

    public void readPriKeyField(Object o, EntityInput input) {
        if (this.priKeyFormat == null) {
            throw new IllegalStateException("No primary key: " + o.getClass().getName());
        }
        ((Enhanced)o).bdbReadPriKeyField(input, this.priKeyFormat);
    }

    public void writeSecKeyFields(Object o, EntityOutput output) {
        ((Enhanced)o).bdbWriteSecKeyFields(output);
    }

    public void readSecKeyFields(Object o, EntityInput input, int startField, int endField, int superLevel) {
        ((Enhanced)o).bdbReadSecKeyFields(input, startField, endField, superLevel);
    }

    public void writeNonKeyFields(Object o, EntityOutput output) {
        ((Enhanced)o).bdbWriteNonKeyFields(output);
    }

    public void readNonKeyFields(Object o, EntityInput input, int startField, int endField, int superLevel) {
        ((Enhanced)o).bdbReadNonKeyFields(input, startField, endField, superLevel);
    }

    public Object getField(Object o, int field, int superLevel, boolean isSecField) {
        return ((Enhanced)o).bdbGetField(o, field, superLevel, isSecField);
    }

    public void setField(Object o, int field, int superLevel, boolean isSecField, Object value) {
        ((Enhanced)o).bdbSetField(o, field, superLevel, isSecField, value);
    }
}

