/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.txn.TxnEnd;
import java.nio.ByteBuffer;
import javax.transaction.xa.Xid;

public class TxnPrepare
extends TxnEnd
implements Loggable {
    private Xid xid;

    public TxnPrepare(long id, Xid xid) {
        super(id, -1L);
        this.xid = xid;
    }

    public TxnPrepare() {
    }

    public Xid getXid() {
        return this.xid;
    }

    protected String getTagName() {
        return "TxnPrepare";
    }

    public int getLogSize() {
        return 8 + LogUtils.getTimestampLogSize() + LogUtils.getXidSize(this.xid);
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeLong(logBuffer, this.id);
        LogUtils.writeTimestamp(logBuffer, this.time);
        LogUtils.writeXid(logBuffer, this.xid);
    }

    public void readFromLog(ByteBuffer logBuffer, byte entryTypeVersion) {
        this.id = LogUtils.readLong(logBuffer);
        this.time = LogUtils.readTimestamp(logBuffer);
        this.xid = LogUtils.readXid(logBuffer);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<").append(this.getTagName());
        sb.append(" id=\"").append(this.id);
        sb.append("\" xid=\"").append(this.xid);
        sb.append("\" time=\"").append(this.time);
        sb.append("\">");
        sb.append("</").append(this.getTagName()).append(">");
    }
}

