/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.entry.BaseEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.NodeLogEntry;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

public class LNLogEntry
extends BaseEntry
implements LogEntry,
NodeLogEntry {
    private static final byte ABORT_KNOWN_DELETED_MASK = 1;
    private LN ln;
    private DatabaseId dbId;
    private byte[] key;
    private long abortLsn = -1L;
    private boolean abortKnownDeleted;
    private Txn txn;
    private long nodeId;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LNLogEntry(Class LNClass) {
        super(LNClass);
    }

    public LNLogEntry(LogEntryType entryType, LN ln, DatabaseId dbId, byte[] key, long abortLsn, boolean abortKnownDeleted, Txn txn) {
        this.setLogType(entryType);
        this.ln = ln;
        this.dbId = dbId;
        this.key = key;
        this.abortLsn = abortLsn;
        this.abortKnownDeleted = abortKnownDeleted;
        this.txn = txn;
        this.nodeId = ln.getNodeId();
        if (!$assertionsDisabled && entryType.isTransactional() != (txn != null)) {
            throw new AssertionError();
        }
    }

    public void readEntry(LogEntryHeader header, ByteBuffer entryBuffer, boolean readFullItem) throws DatabaseException {
        try {
            if (readFullItem) {
                this.ln = (LN)this.logClass.newInstance();
                this.ln.readFromLog(entryBuffer, header.getVersion());
                this.nodeId = this.ln.getNodeId();
                this.dbId = new DatabaseId();
                this.dbId.readFromLog(entryBuffer, header.getVersion());
                this.key = LogUtils.readByteArray(entryBuffer);
                if (this.entryType.isTransactional()) {
                    this.abortLsn = LogUtils.readLong(entryBuffer);
                    if (DbLsn.getFileNumber(this.abortLsn) == DbLsn.getFileNumber(-1L)) {
                        this.abortLsn = -1L;
                    }
                    this.abortKnownDeleted = (entryBuffer.get() & 1) != 0;
                    this.txn = new Txn();
                    this.txn.readFromLog(entryBuffer, header.getVersion());
                }
            } else {
                int currentPosition = entryBuffer.position();
                int endPosition = currentPosition + header.getItemSize();
                this.nodeId = LogUtils.readLong(entryBuffer);
                entryBuffer.position(endPosition);
                this.ln = null;
            }
        }
        catch (IllegalAccessException e) {
            throw new DatabaseException(e);
        }
        catch (InstantiationException e) {
            throw new DatabaseException(e);
        }
    }

    public StringBuffer dumpEntry(StringBuffer sb, boolean verbose) {
        this.ln.dumpLog(sb, verbose);
        this.dbId.dumpLog(sb, verbose);
        sb.append(Key.dumpString(this.key, 0));
        if (this.entryType.isTransactional()) {
            if (this.abortLsn != -1L) {
                sb.append(DbLsn.toString(this.abortLsn));
            }
            sb.append("<knownDeleted val=\"");
            sb.append(this.abortKnownDeleted ? "true" : "false");
            sb.append("\"/>");
            this.txn.dumpLog(sb, verbose);
        }
        return sb;
    }

    public Object getMainItem() {
        return this.ln;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public long getTransactionId() {
        if (this.entryType.isTransactional()) {
            return this.txn.getId();
        }
        return 0L;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public int getSize() {
        int size = this.ln.getLogSize() + this.dbId.getLogSize() + LogUtils.getByteArrayLogSize(this.key);
        if (this.entryType.isTransactional()) {
            size += LogUtils.getLongLogSize();
            ++size;
            size += this.txn.getLogSize();
        }
        return size;
    }

    public void setLastLoggedSize(int size) {
        this.ln.setLastLoggedSize(size);
    }

    public void writeEntry(LogEntryHeader header, ByteBuffer destBuffer) {
        this.ln.writeToLog(destBuffer);
        this.dbId.writeToLog(destBuffer);
        LogUtils.writeByteArray(destBuffer, this.key);
        if (this.entryType.isTransactional()) {
            LogUtils.writeLong(destBuffer, this.abortLsn);
            byte aKD = 0;
            if (this.abortKnownDeleted) {
                aKD = (byte)(aKD | 1);
            }
            destBuffer.put(aKD);
            this.txn.writeToLog(destBuffer);
        }
    }

    public boolean countAsObsoleteWhenLogged() {
        return this.ln.isDeleted();
    }

    public void postLogWork(long justLoggedLsn) throws DatabaseException {
        if (this.entryType.isTransactional()) {
            this.txn.addLogInfo(justLoggedLsn);
        }
    }

    public LN getLN() {
        return this.ln;
    }

    public DatabaseId getDbId() {
        return this.dbId;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getDupKey() {
        if (this.ln.isDeleted()) {
            return null;
        }
        return this.ln.getData();
    }

    public long getAbortLsn() {
        return this.abortLsn;
    }

    public boolean getAbortKnownDeleted() {
        return this.abortKnownDeleted;
    }

    public Long getTxnId() {
        if (this.entryType.isTransactional()) {
            return new Long(this.txn.getId());
        }
        return null;
    }

    public Txn getUserTxn() {
        if (this.entryType.isTransactional()) {
            return this.txn;
        }
        return null;
    }

    static {
        $assertionsDisabled = !LNLogEntry.class.desiredAssertionStatus();
    }
}

