/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.LatchSupport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DbEnvPool {
    private static DbEnvPool pool = new DbEnvPool();
    private Map envs = new HashMap();

    private DbEnvPool() {
    }

    public static DbEnvPool getInstance() {
        return pool;
    }

    public EnvironmentImplInfo getEnvironment(File envHome, EnvironmentConfig config) throws DatabaseException {
        return this.getEnvironment(envHome, config, true);
    }

    public EnvironmentImplInfo getExistingEnvironment(File envHome) throws DatabaseException {
        return this.getEnvironment(envHome, null, false);
    }

    private synchronized EnvironmentImplInfo getEnvironment(File envHome, EnvironmentConfig config, boolean openIfNeeded) throws DatabaseException {
        boolean found;
        boolean firstHandle = false;
        EnvironmentImpl environmentImpl = null;
        String environmentKey = this.getEnvironmentMapKey(envHome);
        if (this.envs.containsKey(environmentKey)) {
            environmentImpl = (EnvironmentImpl)this.envs.get(environmentKey);
            if (!environmentImpl.isOpen()) {
                if (openIfNeeded) {
                    environmentImpl.open();
                    found = true;
                } else {
                    found = false;
                }
            } else {
                found = true;
            }
        } else if (openIfNeeded) {
            environmentImpl = new EnvironmentImpl(envHome, config);
            this.envs.put(environmentKey, environmentImpl);
            firstHandle = true;
            found = true;
        } else {
            found = false;
        }
        if (found) {
            return new EnvironmentImplInfo(environmentImpl, firstHandle);
        }
        return new EnvironmentImplInfo(null, false);
    }

    synchronized void remove(File envHome) throws DatabaseException {
        this.envs.remove(this.getEnvironmentMapKey(envHome));
        if (this.envs.isEmpty()) {
            LatchSupport.clearNotes();
        }
    }

    public synchronized void clear() {
        this.envs.clear();
    }

    private String getEnvironmentMapKey(File file) throws DatabaseException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
    }

    public static class EnvironmentImplInfo {
        public EnvironmentImpl envImpl;
        public boolean firstHandle = false;

        EnvironmentImplInfo(EnvironmentImpl envImpl, boolean firstHandle) {
            this.envImpl = envImpl;
            this.firstHandle = firstHandle;
        }
    }
}

