/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.engine.client.parser;

import be.yildizgames.common.file.xml.XMLParser;
import be.yildizgames.engine.client.parser.FontDefinition;
import be.yildizgames.engine.client.parser.FontParser;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class XmlFontParser
implements FontParser {
    XmlFontParser() {
    }

    @Override
    public List<FontDefinition> parse(Path xmlFile) {
        ArrayList<FontDefinition> result = new ArrayList<FontDefinition>();
        Document doc = XMLParser.getDocument((Path)xmlFile);
        NodeList fontList = doc.getElementsByTagName("font");
        for (int i = 0; i < fontList.getLength(); ++i) {
            Node font = fontList.item(i);
            NodeList itemList = font.getChildNodes();
            FontDefinition def = new FontDefinition();
            for (int j = 0; j < itemList.getLength(); ++j) {
                Node item = itemList.item(j);
                String itemName = item.getNodeName();
                if ("name".equals(itemName)) {
                    def.setName(item.getTextContent());
                    continue;
                }
                if ("file".equals(itemName)) {
                    def.setPath(item.getTextContent());
                    continue;
                }
                if (!"size".equals(itemName)) continue;
                def.setSize(item.getTextContent());
            }
            result.add(def);
        }
        return result;
    }
}

