/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.engine.client.parser;

import be.yildizgames.module.graphic.material.MaterialPass;

public final class SimpleMaterialDefinition {
    private MaterialPass.Transparency transparency = MaterialPass.Transparency.NONE;
    private String path = "";
    private String glowFile = "";
    private String name = "";
    private boolean affectedByLight = true;
    private MaterialPass.BlendMode blend = MaterialPass.BlendMode.NONE;
    private MaterialPass.SceneBlend sceneBlend1 = MaterialPass.SceneBlend.NONE;
    private MaterialPass.SceneBlend sceneBlend2 = MaterialPass.SceneBlend.NONE;
    private String path2 = "";

    SimpleMaterialDefinition() {
    }

    void setSceneBlend(String value) {
        String[] values = value.split("&");
        this.sceneBlend1 = MaterialPass.SceneBlend.valueOf((String)values[0].toUpperCase());
        this.sceneBlend2 = MaterialPass.SceneBlend.valueOf((String)values[1].toUpperCase());
    }

    void setTransparency(String transparencyMode) {
        switch (transparencyMode) {
            case "alpha": {
                this.transparency = MaterialPass.Transparency.ALPHA;
                break;
            }
            case "color": {
                this.transparency = MaterialPass.Transparency.COLOR;
                break;
            }
            case "none": {
                this.transparency = MaterialPass.Transparency.NONE;
                break;
            }
            default: {
                throw new IllegalArgumentException(transparencyMode + " is not a valid transparency value, only 'alpha', 'color' or 'none' are accepted.");
            }
        }
    }

    void setAffectedByLight(String affected) {
        switch (affected) {
            case "true": {
                this.affectedByLight = true;
                break;
            }
            case "false": {
                this.affectedByLight = false;
                break;
            }
            default: {
                throw new IllegalArgumentException(affected + " is not a valid  value, only 'true' or 'false' are accepted.");
            }
        }
    }

    void setBlend(String blendMode) {
        switch (blendMode) {
            case "add": {
                this.blend = MaterialPass.BlendMode.ADD;
                break;
            }
            case "subtract": {
                this.blend = MaterialPass.BlendMode.SUBTRACT;
                break;
            }
            case "none": {
                this.blend = MaterialPass.BlendMode.NONE;
                break;
            }
            case "min": {
                this.blend = MaterialPass.BlendMode.MIN;
                break;
            }
            case "max": {
                this.blend = MaterialPass.BlendMode.MAX;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown value");
            }
        }
    }

    public MaterialPass.Transparency getTransparency() {
        return this.transparency;
    }

    public String getPath() {
        return this.path;
    }

    public String getGlowFile() {
        return this.glowFile;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAffectedByLight() {
        return this.affectedByLight;
    }

    public MaterialPass.BlendMode getBlend() {
        return this.blend;
    }

    public MaterialPass.SceneBlend getSceneBlend1() {
        return this.sceneBlend1;
    }

    public MaterialPass.SceneBlend getSceneBlend2() {
        return this.sceneBlend2;
    }

    public String getPath2() {
        return this.path2;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setGlowFile(String glowFile) {
        this.glowFile = glowFile;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPath2(String path2) {
        this.path2 = path2;
    }
}

