/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.engine.client.parser;

import be.yildizgames.engine.client.parser.FontParser;
import be.yildizgames.engine.client.parser.GuiParser;
import be.yildizgames.engine.client.parser.MaterialParser;
import be.yildizgames.engine.client.parser.MusicParser;
import be.yildizgames.engine.client.parser.XmlFontParser;
import be.yildizgames.engine.client.parser.XmlGuiParser;
import be.yildizgames.engine.client.parser.XmlMaterialParser;
import be.yildizgames.engine.client.parser.XmlMusicParser;
import be.yildizgames.module.window.ScreenSize;
import java.security.InvalidParameterException;

public final class ParserFactory {
    public static final String UNKNOWN_TYPE = "Unkonwn type.";
    private final ParserType parserType;

    public ParserFactory(ParserType parserType) {
        this.parserType = parserType;
    }

    public MusicParser createMusicParser() {
        switch (this.parserType) {
            case XML: {
                return new XmlMusicParser();
            }
        }
        throw new InvalidParameterException(UNKNOWN_TYPE);
    }

    public MaterialParser createMaterialParser(ScreenSize screen) {
        switch (this.parserType) {
            case XML: {
                return new XmlMaterialParser(screen);
            }
        }
        throw new InvalidParameterException(UNKNOWN_TYPE);
    }

    public FontParser createFontParser() {
        switch (this.parserType) {
            case XML: {
                return new XmlFontParser();
            }
        }
        throw new InvalidParameterException(UNKNOWN_TYPE);
    }

    public GuiParser createGuiParser(ScreenSize screen) {
        switch (this.parserType) {
            case XML: {
                return new XmlGuiParser(screen);
            }
        }
        throw new InvalidParameterException(UNKNOWN_TYPE);
    }

    public static enum ParserType {
        XML;

    }
}

