/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.engine.client.parser;

import be.yildizgames.engine.client.parser.ContainerDefinition;
import be.yildizgames.engine.client.parser.FontParser;
import be.yildizgames.engine.client.parser.GuiParser;
import be.yildizgames.engine.client.parser.MaterialParser;
import be.yildizgames.engine.client.parser.MusicDefinition;
import be.yildizgames.engine.client.parser.MusicParser;
import be.yildizgames.engine.client.parser.ParserException;
import be.yildizgames.engine.client.parser.ParserFactory;
import be.yildizgames.engine.client.parser.PlayListDefinition;
import be.yildizgames.engine.client.parser.SimpleMaterialDefinition;
import be.yildizgames.module.audio.AudioEngine;
import be.yildizgames.module.audio.Music;
import be.yildizgames.module.audio.Playlist;
import be.yildizgames.module.coordinate.BaseCoordinate;
import be.yildizgames.module.graphic.Font;
import be.yildizgames.module.graphic.GraphicEngine;
import be.yildizgames.module.graphic.gui.button.ButtonBuilder;
import be.yildizgames.module.graphic.gui.button.ButtonMaterial;
import be.yildizgames.module.graphic.gui.container.Container;
import be.yildizgames.module.graphic.gui.container.ContainerBuilder;
import be.yildizgames.module.graphic.gui.inputbox.InputBoxBuilder;
import be.yildizgames.module.graphic.gui.textarea.TextAreaBuilder;
import be.yildizgames.module.graphic.gui.textline.TextLineBuilder;
import be.yildizgames.module.graphic.material.Material;
import be.yildizgames.module.graphic.material.TextureUnit;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileParser.class);
    private final ParserFactory parserFactory;
    private final GraphicEngine graphicEngine;
    private final AudioEngine soundEngine;

    protected FileParser(GraphicEngine graphicEngine, AudioEngine soundEngine, ParserFactory factory) {
        this.graphicEngine = graphicEngine;
        this.soundEngine = soundEngine;
        this.parserFactory = factory;
    }

    void addResourcePath(Path folder) throws IOException {
        if (!Files.exists(folder, new LinkOption[0]) || !Files.isDirectory(folder, new LinkOption[0])) {
            throw new IllegalArgumentException(folder.toAbsolutePath().toString() + " is not a valid resource path.");
        }
        MusicParser musicParser = this.parserFactory.createMusicParser();
        MaterialParser materialParser = this.parserFactory.createMaterialParser(this.graphicEngine.getScreenSize());
        FontParser fontParser = this.parserFactory.createFontParser();
        GuiParser guiParser = this.parserFactory.createGuiParser(this.graphicEngine.getScreenSize());
        try (Stream<Path> files = Files.walk(folder, new FileVisitOption[0]);){
            files.filter(s -> s.toString().endsWith(".mat")).forEach(s -> {
                LOGGER.info("Parsing material script {}", s);
                List<SimpleMaterialDefinition> matDef = materialParser.parse((Path)s);
                for (SimpleMaterialDefinition def : matDef) {
                    Material m = this.graphicEngine.getMaterialManager().loadSimpleTexture(def.getName(), def.getPath(), def.getTransparency());
                    if (!def.getPath2().isEmpty()) {
                        TextureUnit unit = m.getTechnique(0).createTexturePass().getUnit(0);
                        unit.setTexture(def.getPath2());
                        m.getTechnique(0).getPass(1).setTransparency(def.getTransparency());
                    }
                    if (!def.getGlowFile().isEmpty()) {
                        m.addGlowTechnique(def.getGlowFile());
                    }
                    if (!def.isAffectedByLight()) {
                        m.disableLight();
                    }
                    m.setBlendMode(def.getBlend());
                    m.setSceneBlend(def.getSceneBlend1(), def.getSceneBlend2());
                }
            });
        }
        files = Files.walk(folder, new FileVisitOption[0]);
        try {
            files.filter(s -> s.toString().endsWith(".pll")).forEach(s -> {
                LOGGER.info("Parsing playlist script {}", s);
                List<PlayListDefinition> playListDef = musicParser.parse((Path)s);
                for (PlayListDefinition def : playListDef) {
                    Playlist p = this.soundEngine.createPlaylist(def.getName());
                    for (MusicDefinition musicDef : def.getMusicList()) {
                        Music m = Music.withName((String)musicDef.getFile(), (String)musicDef.getName());
                        p.addMusic(m);
                    }
                }
            });
        }
        finally {
            if (files != null) {
                files.close();
            }
        }
        files = Files.walk(folder, new FileVisitOption[0]);
        try {
            files.filter(s -> s.toString().endsWith(".fnt")).map(fontParser::parse).forEach(l -> l.forEach(def -> this.graphicEngine.createFont(def.getName(), def.getPath(), def.getSize()).load()));
        }
        finally {
            if (files != null) {
                files.close();
            }
        }
        files = Files.walk(folder, new FileVisitOption[0]);
        try {
            files.filter(s -> s.toString().endsWith(".vew")).forEach(s -> {
                LOGGER.info("Parsing view script {}", s);
                try {
                    guiParser.parse((Path)s).forEach(this::buildView);
                }
                catch (ParserException pe) {
                    LOGGER.error("Error parsing", (Throwable)pe);
                }
            });
        }
        finally {
            if (files != null) {
                files.close();
            }
        }
    }

    private void buildView(ContainerDefinition def) {
        Container container = ((ContainerBuilder)((ContainerBuilder)this.graphicEngine.getGuiFactory().container().withName(def.getName())).withBackground(def.getMaterial()).withCoordinates((BaseCoordinate)def.getCoordinates())).build();
        def.getImageList().forEach(id -> this.graphicEngine.getGuiFactory().image().withName(id.getName()).withBackground(id.getMaterial()).withCoordinates((BaseCoordinate)id.getCoordinates()).build(container));
        def.getTextLineList().forEach(td -> ((TextLineBuilder)((TextLineBuilder)this.graphicEngine.getGuiFactory().textLine().withName(td.getName())).withCoordinates((BaseCoordinate)td.getCoordinates())).withFont(Font.get((String)td.getFont())).build(container));
        def.getButtonList().forEach(bd -> ((ButtonBuilder)((ButtonBuilder)this.graphicEngine.getGuiFactory().button().withName(bd.getName())).withCoordinates((BaseCoordinate)bd.getCoordinates())).withButtonMaterial(new ButtonMaterial(Material.get((String)bd.getMaterial()), Material.get((String)bd.getMaterialHighlight()), Font.get((String)bd.getFont()))).build(container));
        def.getInputBoxList().forEach(ibd -> ((InputBoxBuilder)((InputBoxBuilder)this.graphicEngine.getGuiFactory().inputBox().withName(ibd.getName())).withCoordinates((BaseCoordinate)ibd.getCoordinates())).withFont(ibd.getFont()).withCaptionFont(ibd.getFont()).withBackground(ibd.getMaterial()).withBackgroundHighlight(ibd.getMaterialHighlight()).withCursor(ibd.getMaterialCursor()).build(container));
        def.getTextAreaList().forEach(tad -> ((TextAreaBuilder)((TextAreaBuilder)this.graphicEngine.getGuiFactory().textArea().withName(tad.getName())).withCoordinates((BaseCoordinate)tad.getCoordinates())).withFont(Font.get((String)tad.getFont())).withBackground(Material.get((String)tad.getMaterial())).build(container));
    }
}

