/*
 * This file is part of the Yildiz-Engine project, licenced under the MIT License  (MIT)
 *
 * Copyright (c) 2018 Grégory Van den Borre
 *
 * More infos available: https://www.yildiz-games.be
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this
 * software and associated documentation files (the "Software"), to deal in the Software
 * without restriction, including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS  OR COPYRIGHT  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE  SOFTWARE.
 */

package be.yildizgames.engine.client.parser;

import java.util.ArrayList;
import java.util.List;

/**
 * Data definition to create a Music PlayList from an external resource(i.e
 * parsing a script file).
 *
 * @author Grégory Van den Borre
 */
public final class PlayListDefinition {

    /**
     * PlayList music list.
     */
    private final List<MusicDefinition> musicList = new ArrayList<>();
    /**
     * PlayList name, must be unique.
     */
    private String name = "";

    /**
     * Simple constructor, initialize with empty values.
     */
    PlayListDefinition() {
        super();
    }

    /**
     * Add a music to the play list.
     *
     * @param musicDef Definition of the music to add.
     */
    void addMusic(final MusicDefinition musicDef) {
        this.musicList.add(musicDef);
    }

    public List<MusicDefinition> getMusicList() {
        return musicList;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
