/*
 * Decompiled with CFR 0.152.
 */
package com.d2lvalence.idkeyauth.implementation;

import com.d2lvalence.idkeyauth.codec.binary.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class D2LSigner {
    public static String getBase64HashString(String key, String data) {
        byte[] keyBytes = D2LSigner.getBytes(key);
        byte[] dataBytes = D2LSigner.getBytes(data);
        byte[] hash = D2LSigner.computeHash(keyBytes, dataBytes);
        return new String(Base64.encodeBase64(hash, false, true));
    }

    private static byte[] getBytes(String key) {
        return key.getBytes();
    }

    private static byte[] computeHash(byte[] keyBytes, byte[] dataBytes) {
        try {
            Mac hmacSha256 = Mac.getInstance("HmacSHA256");
            SecretKeySpec key = new SecretKeySpec(keyBytes, "HmacSHA256");
            hmacSha256.init(key);
            byte[] b = hmacSha256.doFinal(dataBytes);
            return b;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

