/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.termgenerator;

import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.rml.Utils;
import be.ugent.rml.extractor.ReferenceExtractor;
import be.ugent.rml.functions.FunctionUtils;
import be.ugent.rml.functions.SingleRecordFunctionExecutor;
import be.ugent.rml.term.Literal;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import be.ugent.rml.termgenerator.TermGenerator;
import java.util.ArrayList;
import java.util.List;

public class LiteralGenerator
extends TermGenerator {
    private final SingleRecordFunctionExecutor languageExecutor;
    private final Term datatype;
    private final int maxNumberOfTerms;

    private LiteralGenerator(SingleRecordFunctionExecutor functionExecutor, SingleRecordFunctionExecutor languageExecutor, Term datatype, int maxNumberOfTerms) {
        super(functionExecutor);
        this.languageExecutor = languageExecutor;
        this.datatype = datatype;
        this.maxNumberOfTerms = maxNumberOfTerms;
    }

    public LiteralGenerator(SingleRecordFunctionExecutor functionExecutor, SingleRecordFunctionExecutor languageExecutor) {
        this(functionExecutor, languageExecutor, null, 0);
    }

    public LiteralGenerator(SingleRecordFunctionExecutor functionExecutor, Term datatype) {
        this(functionExecutor, null, datatype, 0);
    }

    public LiteralGenerator(SingleRecordFunctionExecutor functionExecutor) {
        this(functionExecutor, null, null, 0);
    }

    @Override
    public List<Term> generate(Record record) throws Exception {
        ArrayList<Term> objects = new ArrayList<Term>();
        List<String> objectStrings = FunctionUtils.functionObjectToList(this.functionExecutor.execute(record));
        String dataTypeSource = null;
        if (this.functionExecutor instanceof ReferenceExtractor) {
            dataTypeSource = record.getDataType(((ReferenceExtractor)this.functionExecutor).reference);
        }
        if (!objectStrings.isEmpty()) {
            String finalDataTypeSource = dataTypeSource;
            objectStrings.forEach(objectString -> {
                if (this.languageExecutor != null) {
                    try {
                        List<String> languages = FunctionUtils.functionObjectToList(this.languageExecutor.execute(record));
                        if (!languages.isEmpty()) {
                            String language = languages.get(0);
                            if (!Utils.isValidrrLanguage(language)) {
                                throw new RuntimeException(String.format("Language tag \"%s\" does not conform to BCP 47 standards", language));
                            }
                            objects.add(new Literal((String)objectString, language));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (this.datatype != null) {
                    objects.add(new Literal((String)objectString, this.datatype));
                } else if (finalDataTypeSource != null) {
                    if (this.functionExecutor instanceof ReferenceExtractor) {
                        objectString = Utils.transformDatatypeString(objectString, finalDataTypeSource);
                    }
                    objects.add(new Literal((String)objectString, new NamedNode(finalDataTypeSource)));
                } else {
                    objects.add(new Literal((String)objectString));
                }
            });
        }
        if (this.maxNumberOfTerms != 0) {
            return objects.subList(0, this.maxNumberOfTerms);
        }
        return objects;
    }
}

