/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.target;

import be.ugent.rml.Utils;
import be.ugent.rml.store.Quad;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.target.DirectHttpRequestTarget;
import be.ugent.rml.target.HttpRequestTargetHelper;
import be.ugent.rml.target.LinkedHttpRequestTarget;
import be.ugent.rml.target.LocalFileTarget;
import be.ugent.rml.target.SPARQLEndpointTarget;
import be.ugent.rml.target.Target;
import be.ugent.rml.term.Literal;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetFactory {
    private final String basePath;
    private static final Logger logger = LoggerFactory.getLogger(TargetFactory.class);
    private HttpRequestTargetHelper httpRequestTargetHelper;

    public TargetFactory(String basePath) {
        this.basePath = basePath;
        try {
            this.httpRequestTargetHelper = new HttpRequestTargetHelper();
        }
        catch (JoseException e) {
            logger.error("Failed to initialize new HttpRequestTargetHelper: {}", (Object)e.getMessage());
        }
    }

    private void detectLDESEventStreamTarget(Term logicalTarget, List<Quad> metadata, QuadStore rmlStore, QuadStore outputStore) {
        List<Term> types = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalTarget, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), null));
        for (Term type : types) {
            if (type.getValue().equals("https://w3id.org/ldes#EventStreamTarget")) {
                logger.error("'{}EventStreamTarget' is not supported anymore. Use '{}/EventStreamTarget'. Not generating LDES metadata!", (Object)"https://w3id.org/ldes#", (Object)"http://semweb.mmlab.be/ns/rml-target#");
                return;
            }
            if (!type.getValue().equals("http://semweb.mmlab.be/ns/rml-target#EventStreamTarget")) continue;
            logger.debug("Found RMLT EventStreamTarget");
            NamedNode ldes_iri = null;
            Term ldes = null;
            Term versionOfPathObj = null;
            Term timestampPathObj = null;
            Term memberTargetClass = null;
            boolean ldesGenerateImmutableIRI = false;
            try {
                Term iri = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalTarget, new NamedNode("http://semweb.mmlab.be/ns/rml-target#ldesBaseIRI"), null)).get(0);
                ldes_iri = new NamedNode(iri.getValue());
                logger.debug("LDES base IRI: {}", (Object)iri.getValue());
                metadata.add(new Quad(ldes_iri, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), new NamedNode("https://w3id.org/ldes#EventStream")));
            }
            catch (IndexOutOfBoundsException e) {
                logger.debug("No LDES metadata will be generated since no LDES base IRI was specified");
            }
            try {
                ldes = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalTarget, new NamedNode("http://semweb.mmlab.be/ns/rml-target#ldes"), null)).get(0);
            }
            catch (IndexOutOfBoundsException e) {
                logger.debug("No LDES member metadata found.");
            }
            if (ldes != null) {
                if (ldes_iri != null) {
                    try {
                        Term shape = Utils.getObjectsFromQuads(rmlStore.getQuads(ldes, new NamedNode("https://w3id.org/tree#shape"), null)).get(0);
                        logger.debug("SHACL shape: {}", (Object)shape.getValue());
                        metadata.add(new Quad(ldes_iri, new NamedNode("https://w3id.org/tree#shape"), shape));
                    }
                    catch (IndexOutOfBoundsException e) {
                        logger.debug("No TREE SHACL shape specified for LDES.");
                    }
                }
                try {
                    versionOfPathObj = Utils.getObjectsFromQuads(rmlStore.getQuads(ldes, new NamedNode("https://w3id.org/ldes#versionOfPath"), null)).get(0);
                    logger.debug("VersionOf path: {}", (Object)versionOfPathObj.getValue());
                    if (ldes_iri != null) {
                        metadata.add(new Quad(ldes_iri, new NamedNode("https://w3id.org/ldes#versionOfPath"), versionOfPathObj));
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    logger.debug("No LDES versionOf path found");
                }
                try {
                    timestampPathObj = Utils.getObjectsFromQuads(rmlStore.getQuads(ldes, new NamedNode("https://w3id.org/ldes#timestampPath"), null)).get(0);
                    if (ldes_iri != null) {
                        metadata.add(new Quad(ldes_iri, new NamedNode("https://w3id.org/ldes#timestampPath"), timestampPathObj));
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    logger.debug("No LDES timestamp path found");
                }
            }
            try {
                Term generateImmutableIRIObj = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalTarget, new NamedNode("http://semweb.mmlab.be/ns/rml-target#ldesGenerateImmutableIRI"), null)).get(0);
                ldesGenerateImmutableIRI = generateImmutableIRIObj.getValue().equals("true");
                logger.debug("LDES Immutable IRI generation: {}", (Object)(ldesGenerateImmutableIRI ? "yes" : "no"));
            }
            catch (IndexOutOfBoundsException e) {
                logger.debug("No LDES generateImmutableIRI found");
            }
            try {
                memberTargetClass = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalTarget, new NamedNode("http://semweb.mmlab.be/ns/rml-target#ldesMemberTargetClass"), null)).get(0);
                logger.debug("LDES member target class: {}", (Object)memberTargetClass);
            }
            catch (IndexOutOfBoundsException e) {
                logger.debug("No LDES member target class found");
            }
            List<Term> ldesMembers = memberTargetClass != null ? Utils.getSubjectsFromQuads(outputStore.getQuads(null, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), memberTargetClass)) : outputStore.getSubjects();
            long currentTime = System.currentTimeMillis();
            long seed = (long)(Math.random() * 1000.0);
            long index = 0L;
            HashSet<Term> processedMembers = new HashSet<Term>();
            for (Term m : ldesMembers) {
                Term memberIRI = m;
                if (processedMembers.contains(memberIRI)) continue;
                processedMembers.add(memberIRI);
                ++index;
                if (ldesGenerateImmutableIRI) {
                    memberIRI = new NamedNode(m.getValue() + "#" + (currentTime + seed + index));
                    if (versionOfPathObj != null) {
                        List<Term> versionOfObj = Utils.getObjectsFromQuads(outputStore.getQuads(m, versionOfPathObj, null));
                        if (versionOfObj.isEmpty()) {
                            outputStore.addQuad(new Quad(memberIRI, versionOfPathObj, m));
                        } else {
                            for (Term v : versionOfObj) {
                                outputStore.addQuad(new Quad(memberIRI, versionOfPathObj, v));
                            }
                        }
                    }
                    if (timestampPathObj != null) {
                        List<Term> timestampObj = Utils.getObjectsFromQuads(outputStore.getQuads(m, timestampPathObj, null));
                        if (timestampObj.isEmpty()) {
                            outputStore.addQuad(new Quad(memberIRI, timestampPathObj, new Literal(Instant.ofEpochMilli(currentTime).toString(), new NamedNode("http://www.w3.org/2001/XMLSchema#dateTime"))));
                        } else {
                            for (Term v : timestampObj) {
                                outputStore.addQuad(new Quad(memberIRI, timestampPathObj, v));
                            }
                        }
                    }
                    List<Quad> memberProperties = outputStore.getQuads(m, null, null);
                    for (Quad property : memberProperties) {
                        outputStore.addQuad(memberIRI, property.getPredicate(), property.getObject(), property.getGraph());
                        outputStore.removeQuads(property);
                    }
                }
                if (ldes_iri == null) continue;
                Quad q = new Quad(ldes_iri, new NamedNode("https://w3id.org/tree#member"), memberIRI);
                metadata.add(q);
            }
        }
    }

    public Target getTarget(Term logicalTarget, QuadStore rmlStore, QuadStore outputStore) throws IOException {
        String serializationFormat = "nquads";
        String compression = null;
        ArrayList<Quad> metadata = new ArrayList<Quad>();
        if (logicalTarget instanceof Literal) {
            logger.warn("Legacy string output path for Target found, do not use, this is only supported for backwards compatibility reasons.");
            String location = logicalTarget.getValue();
            if (location.endsWith(".nq")) {
                serializationFormat = "nquads";
            } else if (location.endsWith(".nt")) {
                serializationFormat = "ntriples";
            } else if (location.endsWith(".ttl")) {
                serializationFormat = "turtle";
            } else if (location.endsWith(".jsonld")) {
                serializationFormat = "jsonld";
            } else {
                throw new UnsupportedOperationException("Serialization format for " + location + " not implemented!");
            }
            return new LocalFileTarget(location, this.basePath, serializationFormat, null, metadata);
        }
        List<Term> targets = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalTarget, new NamedNode("http://w3id.org/rml/target"), null));
        try {
            String sf;
            serializationFormat = switch (sf = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalTarget, new NamedNode("http://w3id.org/rml/serialization"), null)).get(0).getValue()) {
                case "http://www.w3.org/ns/formats/N-Triples" -> "ntriples";
                case "http://www.w3.org/ns/formats/N-Quads" -> "nquads";
                case "http://www.w3.org/ns/formats/JSON-LD" -> "jsonld";
                case "http://www.w3.org/ns/formats/Turtle" -> "turtle";
                case "http://www.w3.org/ns/formats/TriG" -> "trig";
                default -> throw new UnsupportedOperationException("Serialization format " + sf + " not implemented!");
            };
        }
        catch (IndexOutOfBoundsException e) {
            logger.debug("No serialization format specified, falling back to default N-Quads");
        }
        logger.debug("Serialization: " + serializationFormat);
        try {
            Term comp = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalTarget, new NamedNode("http://w3id.org/rml/compression"), null)).get(0);
            compression = switch (comp.getValue()) {
                case "http://semweb.mmlab.be/ns/rml-compression#gzip" -> "gzip";
                case "http://w3id.org/rml/gzip" -> "gzip";
                case "http://semweb.mmlab.be/ns/rml-compression#zip" -> "zip";
                case "http://w3id.org/rml/zip" -> "zip";
                default -> throw new UnsupportedOperationException("Compression " + String.valueOf(comp) + " is not implemented!");
            };
            logger.debug("Compression: {}", (Object)compression);
        }
        catch (IndexOutOfBoundsException e) {
            logger.debug("Compression disabled");
        }
        this.detectLDESEventStreamTarget(logicalTarget, metadata, rmlStore, outputStore);
        if (!targets.isEmpty()) {
            Term t = targets.get(0);
            logger.debug("getTarget() for {}", (Object)t.toString());
            List<Term> possibleTypes = Utils.getObjectsFromQuads(rmlStore.getQuads(t, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), null));
            String targetType = null;
            for (Term p : possibleTypes) {
                if (p.getValue().contains("http://w3id.org/rml/Target")) continue;
                targetType = p.getValue();
                break;
            }
            logger.debug("Target is IRI, target type: {}", targetType);
            Target target = switch (targetType) {
                case "http://rdfs.org/ns/void#Dataset" -> {
                    logger.debug("Target is a VoID Dataset");
                    String location = Utils.getObjectsFromQuads(rmlStore.getQuads(t, new NamedNode("http://rdfs.org/ns/void#dataDump"), null)).get(0).getValue();
                    location = location.replace("file://", "");
                    logger.debug("VoID datadump location: {}", (Object)location);
                    yield new LocalFileTarget(location, this.basePath, serializationFormat, compression, metadata);
                }
                case "http://www.w3.org/ns/dcat#Dataset" -> {
                    logger.debug("Target is a DCAT Dataset");
                    String location = Utils.getObjectsFromQuads(rmlStore.getQuads(t, new NamedNode("http://www.w3.org/ns/dcat#dataDump"), null)).get(0).getValue();
                    location = location.replace("file://", "");
                    logger.debug("DCAT datadump location: {}", (Object)location);
                    yield new LocalFileTarget(location, this.basePath, serializationFormat, compression, metadata);
                }
                case "http://www.w3.org/ns/dcat#Distribution" -> {
                    logger.debug("Target is a DCAT Distribution");
                    String location = Utils.getObjectsFromQuads(rmlStore.getQuads(t, new NamedNode("http://www.w3.org/ns/dcat#accessUrl"), null)).get(0).getValue();
                    location = location.replace("file://", "");
                    logger.debug("DCAT accessUrl location: {}", (Object)location);
                    yield new LocalFileTarget(location, this.basePath, serializationFormat, compression, metadata);
                }
                case "http://www.w3.org/ns/sparql-service-description#Service" -> {
                    logger.debug("Target is a SD Service");
                    String endpoint = Utils.getObjectsFromQuads(rmlStore.getQuads(t, new NamedNode("http://www.w3.org/ns/sparql-service-description#endpoint"), null)).get(0).getValue();
                    String supportedLanguage = Utils.getObjectsFromQuads(rmlStore.getQuads(t, new NamedNode("http://www.w3.org/ns/sparql-service-description#supportedLanguage"), null)).get(0).getValue();
                    logger.debug("SPARQL Service endpoint: {}", (Object)endpoint);
                    logger.debug("SPARQL Service supported language: {}", (Object)supportedLanguage);
                    if (!supportedLanguage.equals("http://www.w3.org/ns/sparql-service-description#SPARQL11Update")) {
                        throw new IllegalArgumentException("SPARQL Service target must support SPARQL Update!");
                    }
                    yield new SPARQLEndpointTarget(endpoint, metadata);
                }
                case "https://w3id.org/imec/rml/ns/extensions#DirectHttpRequest" -> {
                    logger.debug("Target is a direct HTTP request");
                    Map<String, String> httpRequestInfo = this.parseHttpRequest(rmlStore, t);
                    String absoluteURI = this.getRequiredValue(t, new NamedNode("http://www.w3.org/2011/http#absoluteURI"), rmlStore);
                    httpRequestInfo.put("absoluteURI", absoluteURI);
                    yield new DirectHttpRequestTarget(httpRequestInfo, serializationFormat, metadata, this.httpRequestTargetHelper);
                }
                case "https://w3id.org/imec/rml/ns/extensions#LinkedHttpRequest" -> {
                    logger.debug("Target is a linked HTTP request");
                    Map<String, String> httpRequestInfo = this.parseHttpRequest(rmlStore, t);
                    String linkingAbsoluteURI = this.getRequiredValue(t, new NamedNode("https://w3id.org/imec/rml/ns/extensions#linkingAbsoluteURI"), rmlStore);
                    String linkRelation = this.getRequiredValue(t, new NamedNode("https://w3id.org/imec/rml/ns/extensions#linkRelation"), rmlStore);
                    httpRequestInfo.put("linkingAbsoluteURI", linkingAbsoluteURI);
                    httpRequestInfo.put("linkRelation", linkRelation);
                    yield new LinkedHttpRequestTarget(httpRequestInfo, serializationFormat, metadata, this.httpRequestTargetHelper);
                }
                default -> throw new UnsupportedOperationException("Not implemented");
            };
            logger.debug("Target created: {}", (Object)target);
            return target;
        }
        throw new Error("Logical Target " + logicalTarget.getValue() + " does not have target.");
    }

    private Map<String, String> parseHttpRequest(QuadStore rmlStore, Term t) {
        HashMap<String, String> httpRequestInfo = new HashMap<String, String>();
        this.putOptionalValue(t, new NamedNode("http://www.w3.org/2011/http#methodName"), rmlStore, httpRequestInfo, "methodName");
        this.putOptionalValue(t, new NamedNode("https://w3id.org/imec/rml/ns/extensions#contentTypeHeader"), rmlStore, httpRequestInfo, "contentType");
        List<Term> authentications = Utils.getObjectsFromQuads(rmlStore.getQuads(t, new NamedNode("https://w3id.org/imec/rml/ns/extensions#userAuthentication"), null));
        if (!authentications.isEmpty()) {
            Term userAuthentication = authentications.get(0);
            String authenticationType = this.getRequiredValue(userAuthentication, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), rmlStore);
            httpRequestInfo.put("authenticationType", authenticationType);
            switch (authenticationType) {
                case "https://w3id.org/imec/rml/ns/extensions#CssClientCredentialsAuthentication": {
                    String email = this.getRequiredValue(userAuthentication, new NamedNode("https://w3id.org/imec/rml/ns/extensions#authEmail"), rmlStore);
                    String password = this.getRequiredValue(userAuthentication, new NamedNode("https://w3id.org/imec/rml/ns/extensions#authPassword"), rmlStore);
                    String oidcIssuer = this.getRequiredValue(userAuthentication, new NamedNode("https://w3id.org/imec/rml/ns/extensions#authOidcIssuer"), rmlStore);
                    String webId = this.getRequiredValue(userAuthentication, new NamedNode("https://w3id.org/imec/rml/ns/extensions#authWebId"), rmlStore);
                    httpRequestInfo.put("email", email);
                    httpRequestInfo.put("password", password);
                    httpRequestInfo.put("oidcIssuer", oidcIssuer);
                    httpRequestInfo.put("webId", webId);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("User authentication type " + authenticationType + "is not implemented");
                }
            }
        }
        return httpRequestInfo;
    }

    private String getRequiredValue(Term subject, Term predicate, QuadStore rmlStore) throws Error {
        List<Term> terms = Utils.getObjectsFromQuads(rmlStore.getQuads(subject, predicate, null));
        if (terms.isEmpty()) {
            throw new Error(String.valueOf(subject) + " has no value for predicate " + String.valueOf(predicate));
        }
        return terms.get(0).getValue();
    }

    private void putOptionalValue(Term subject, Term predicate, QuadStore rmlStore, HashMap<String, String> map, String key) {
        List<Term> terms = Utils.getObjectsFromQuads(rmlStore.getQuads(subject, predicate, null));
        if (!terms.isEmpty()) {
            map.put(key, terms.get(0).getValue());
        }
    }
}

