/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.target;

import be.ugent.rml.store.Quad;
import be.ugent.rml.target.Target;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.client.HttpResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPARQLEndpointTarget
implements Target {
    private final String url;
    private final List<Quad> metadata;
    private final File tempFile;
    private static final Logger logger = LoggerFactory.getLogger(SPARQLEndpointTarget.class);
    private static final int BUFFER_SIZE = 8192;
    private static final String serializationFormat = "ntriples";

    public SPARQLEndpointTarget(String url, List<Quad> metadata) throws IOException {
        this.url = url;
        this.metadata = metadata;
        this.tempFile = File.createTempFile("rmlmapper-", ".nt");
        this.tempFile.deleteOnExit();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.tempFile);
    }

    @Override
    public String getSerializationFormat() {
        return serializationFormat;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (o instanceof SPARQLEndpointTarget) {
            SPARQLEndpointTarget target = (SPARQLEndpointTarget)o;
            return this.url.equals(target.getUrl());
        }
        return false;
    }

    @Override
    public void close() {
        logger.debug("Closing target");
        try {
            int length;
            URL url = new URL(this.url);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Content-Type", "application/sparql-update");
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            File turtle = new File(this.tempFile.getAbsolutePath());
            FileInputStream in = new FileInputStream(turtle);
            OutputStream out = connection.getOutputStream();
            out.write("INSERT DATA {".getBytes(StandardCharsets.UTF_8));
            byte[] buffer = new byte[8192];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                out.write(buffer, 0, length);
            }
            out.write("}".getBytes(StandardCharsets.UTF_8));
            ((InputStream)in).close();
            out.close();
            int code = connection.getResponseCode();
            if (code >= 300) {
                throw new HttpResponseException(code, "Executing SPARQL UPDATE query failed (" + code + ")");
            }
        }
        catch (Exception e) {
            logger.error("Failed to close target: {}", (Object)e, (Object)e);
        }
    }

    @Override
    public List<Quad> getMetadata() {
        return this.metadata;
    }
}

