/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.store;

import be.ugent.rml.store.Quad;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.Term;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.rio.RDFFormat;

public class SimpleQuadStore
extends QuadStore {
    private List<Quad> quads = new ArrayList<Quad>();

    @Override
    public void removeDuplicates() {
        ArrayList<Quad> quadsWithDuplicates = new ArrayList<Quad>();
        for (Quad q : this.quads) {
            int i;
            for (i = 0; i < quadsWithDuplicates.size() && (!((Quad)quadsWithDuplicates.get(i)).getSubject().equals(q.getSubject()) || !((Quad)quadsWithDuplicates.get(i)).getObject().equals(q.getObject()) || !((Quad)quadsWithDuplicates.get(i)).getPredicate().equals(q.getPredicate()) || ((Quad)quadsWithDuplicates.get(i)).getGraph() == null && q.getGraph() != null || ((Quad)quadsWithDuplicates.get(i)).getGraph() != null && q.getGraph() == null || (((Quad)quadsWithDuplicates.get(i)).getGraph() != null || q.getGraph() != null) && !((Quad)quadsWithDuplicates.get(i)).getGraph().equals(q.getGraph())); ++i) {
            }
            if (i != quadsWithDuplicates.size()) continue;
            quadsWithDuplicates.add(q);
        }
        this.quads = quadsWithDuplicates;
    }

    @Override
    public List<Term> getSubjects() {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (Quad q : this.quads) {
            terms.add(q.getSubject());
        }
        return terms;
    }

    @Override
    public void addQuad(Term subject, Term predicate, Term object, Term graph) {
        if (subject != null && predicate != null && object != null) {
            this.quads.add(new Quad(subject, predicate, object, graph));
        }
    }

    @Override
    public List<Quad> getQuads(Term subject, Term predicate, Term object, Term graph) {
        Quad quad = new Quad(subject, predicate, object, graph);
        ArrayList<Quad> filteredQuads = new ArrayList<Quad>();
        for (Quad q : this.quads) {
            if (quad.compareTo(q) != 0) continue;
            filteredQuads.add(q);
        }
        return filteredQuads;
    }

    @Override
    public void copyNameSpaces(QuadStore store) {
    }

    @Override
    public void addNameSpace(String prefix, String IRI2) {
    }

    @Override
    public void removeNameSpace(String prefix) {
    }

    @Override
    public boolean isEmpty() {
        return this.quads.isEmpty();
    }

    @Override
    public int size() {
        return this.quads.size();
    }

    @Override
    public void read(InputStream is, String base, RDFFormat format) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    @Override
    public void write(Writer out, String format) throws IOException {
        switch (format) {
            case "nquads": {
                this.toNQuads(out);
                break;
            }
            default: {
                throw new Error("Serialization " + format + " not supported");
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    @Override
    public void removeQuads(Term subject, Term predicate, Term object, Term graph) {
        List<Quad> matches = this.getQuads(subject, predicate, object, graph);
        matches.forEach(m -> this.quads.remove(m));
    }

    @Override
    public boolean contains(Term subject, Term predicate, Term object, Term graph) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    @Override
    public boolean isIsomorphic(QuadStore store) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    @Override
    public boolean isSubset(QuadStore store) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    private void toNQuads(Writer out) throws IOException {
        for (Quad q : this.quads) {
            out.write(this.getNQuadOfQuad(q) + "\n");
        }
    }

    private String getNQuadOfQuad(Quad q) {
        String str = String.valueOf(q.getSubject()) + " " + String.valueOf(q.getPredicate()) + " " + String.valueOf(q.getObject());
        if (q.getGraph() != null) {
            str = str + " " + String.valueOf(q.getGraph());
        }
        str = str + ".";
        return str;
    }
}

