/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.store;

import be.ugent.rml.store.Quad;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.BlankNode;
import be.ugent.rml.term.Literal;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDF4JStore
extends QuadStore {
    private static final Logger logger = LoggerFactory.getLogger(RDF4JStore.class);
    private Model model = new TreeModel();
    private int triplesWithGraphCounter = 0;
    private static final Pattern languagePattern = Pattern.compile("^\"(.*)\"@([^@]*)", 32);
    private static final Pattern dataTypePattern = Pattern.compile("^\"(.*)\"\\^\\^<([^>]*)>", 32);
    private static final Pattern literalPattern = Pattern.compile("^\"(.*)\"$", 32);

    @Override
    public void removeDuplicates() {
    }

    @Override
    public void addQuad(Term subject, Term predicate, Term object, Term graph) {
        Resource s = this.getFilterSubject(subject);
        IRI p = this.getFilterPredicate(predicate);
        Value o = this.getFilterObject(object);
        Resource g = this.getFilterGraph(graph);
        this.model.add(s, p, o, new Resource[]{g});
        if (g != null) {
            ++this.triplesWithGraphCounter;
        }
    }

    @Override
    public List<Term> getSubjects() {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (Resource subject : this.model.subjects()) {
            terms.add(this.convertStringToTerm(subject.toString()));
        }
        return terms;
    }

    @Override
    public List<Quad> getQuads(Term subject, Term predicate, Term object, Term graph) {
        Resource filterSubject = this.getFilterSubject(subject);
        IRI filterPredicate = this.getFilterPredicate(predicate);
        Value filterObject = this.getFilterObject(object);
        Resource filterGraph = this.getFilterGraph(graph);
        Model result = graph != null ? this.model.filter(filterSubject, filterPredicate, filterObject, new Resource[]{filterGraph}) : this.model.filter(filterSubject, filterPredicate, filterObject, new Resource[0]);
        ArrayList<Quad> quads = new ArrayList<Quad>();
        for (Statement st : result) {
            Term s = this.convertStringToTerm(st.getSubject().toString());
            Term p = this.convertStringToTerm(st.getPredicate().toString());
            Term o = this.convertStringToTerm(st.getObject().toString());
            if (st.getContext() == null) {
                quads.add(new Quad(s, p, o));
                continue;
            }
            quads.add(new Quad(s, p, o, this.convertStringToTerm(st.getContext().toString())));
        }
        return quads;
    }

    @Override
    public void copyNameSpaces(QuadStore store) {
        if (!(store instanceof RDF4JStore)) {
            throw new UnsupportedOperationException();
        }
        RDF4JStore rdf4JStore = (RDF4JStore)store;
        rdf4JStore.getModel().getNamespaces().forEach(namespace -> this.model.setNamespace(namespace));
    }

    @Override
    public void addNameSpace(String prefix, String IRI2) {
        this.getModel().getNamespaces().add(new SimpleNamespace(prefix, IRI2));
    }

    @Override
    public void removeNameSpace(String prefix) {
        Set namespaces = this.getModel().getNamespaces();
        namespaces.removeIf(namespace -> namespace.getPrefix().equals(prefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(InputStream is, String base, RDFFormat format) throws Exception {
        if (base == null) {
            base = "";
        }
        try {
            RDFParser parser = Rio.createParser((RDFFormat)format);
            parser.set((RioSetting)BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
            parser.setRDFHandler((RDFHandler)new StatementCollector((Collection)this.model));
            parser.parse(is, base);
        }
        finally {
            is.close();
        }
    }

    @Override
    public void write(Writer out, String format) throws Exception {
        switch (format) {
            case "turtle": {
                Rio.write((Iterable)this.model, (Writer)out, (RDFFormat)RDFFormat.TURTLE);
                if (this.triplesWithGraphCounter <= 0) break;
                logger.warn("There are graphs generated. However, Turtle does not support graphs. Use Trig instead.");
                break;
            }
            case "trig": {
                Rio.write((Iterable)this.model, (Writer)out, (RDFFormat)RDFFormat.TRIG);
                break;
            }
            case "trix": {
                Rio.write((Iterable)this.model, (Writer)out, (RDFFormat)RDFFormat.TRIX);
                break;
            }
            case "jsonld": {
                Rio.write((Iterable)this.model, (Writer)out, (RDFFormat)RDFFormat.JSONLD);
                break;
            }
            case "nquads": {
                Rio.write((Iterable)this.model, (Writer)out, (RDFFormat)RDFFormat.NQUADS);
                break;
            }
            case "ntriples": {
                Rio.write((Iterable)this.model, (Writer)out, (RDFFormat)RDFFormat.NTRIPLES);
                break;
            }
            default: {
                throw new Exception("Serialization " + format + " not supported");
            }
        }
    }

    public String getBase() {
        Optional base = this.model.getNamespace("");
        if (base.isPresent()) {
            return ((Namespace)base.get()).getName();
        }
        return "";
    }

    @Override
    public boolean isEmpty() {
        return this.model.isEmpty();
    }

    @Override
    public int size() {
        return this.model.size();
    }

    public Model getModel() {
        return this.model;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof RDF4JStore) {
            RDF4JStore otherStore = (RDF4JStore)o;
            return Models.isomorphic((Iterable)this.model, (Iterable)otherStore.getModel());
        }
        return false;
    }

    @Override
    public void removeQuads(Term subject, Term predicate, Term object, Term graph) {
        Resource filterSubject = this.getFilterSubject(subject);
        IRI filterPredicate = this.getFilterPredicate(predicate);
        Value filterObject = this.getFilterObject(object);
        Resource filterGraph = this.getFilterGraph(graph);
        this.model.remove(filterSubject, filterPredicate, filterObject, new Resource[]{filterGraph});
    }

    @Override
    public boolean contains(Term subject, Term predicate, Term object, Term graph) {
        Resource filterSubject = this.getFilterSubject(subject);
        IRI filterPredicate = this.getFilterPredicate(predicate);
        Value filterObject = this.getFilterObject(object);
        Resource filterGraph = this.getFilterGraph(graph);
        return this.model.contains(filterSubject, filterPredicate, filterObject, new Resource[]{filterGraph});
    }

    @Override
    public boolean isIsomorphic(QuadStore store) {
        if (store instanceof RDF4JStore) {
            RDF4JStore rdf4JStore = (RDF4JStore)store;
            return Models.isomorphic((Iterable)this.model, (Iterable)rdf4JStore.getModel());
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSubset(QuadStore store) {
        if (store instanceof RDF4JStore) {
            RDF4JStore rdf4JStore = (RDF4JStore)store;
            return Models.isSubset((Set)this.model, (Set)rdf4JStore.getModel());
        }
        throw new UnsupportedOperationException();
    }

    private Resource getFilterSubject(Term subject) {
        if (subject != null) {
            SimpleValueFactory vf = SimpleValueFactory.getInstance();
            if (subject instanceof BlankNode) {
                return vf.createBNode(subject.getValue());
            }
            return vf.createIRI(subject.getValue());
        }
        return null;
    }

    private IRI getFilterPredicate(Term predicate) {
        if (predicate != null) {
            return SimpleValueFactory.getInstance().createIRI(predicate.getValue());
        }
        return null;
    }

    private Value getFilterObject(Term object) {
        if (object != null) {
            SimpleValueFactory vf = SimpleValueFactory.getInstance();
            if (object instanceof BlankNode) {
                return vf.createBNode(object.getValue());
            }
            if (object instanceof Literal) {
                Literal literal = (Literal)object;
                if (literal.getLanguage().isPresent()) {
                    return vf.createLiteral(object.getValue(), (String)literal.getLanguage().get());
                }
                if (literal.getDatatype() != null) {
                    return vf.createLiteral(object.getValue(), vf.createIRI(literal.getDatatype().stringValue()));
                }
                return vf.createLiteral(object.getValue());
            }
            return vf.createIRI(object.getValue());
        }
        return null;
    }

    private Resource getFilterGraph(Term graph) {
        return this.getFilterSubject(graph);
    }

    private Term convertStringToTerm(String str) {
        if (str.startsWith("_:")) {
            return new BlankNode(str.replace("_:", ""));
        }
        if (str.startsWith("\"\"\"")) {
            return new Literal(str.substring(4, str.length() - 3));
        }
        if (str.startsWith("\"")) {
            boolean hasLanguage = str.contains("@") && str.lastIndexOf("@") > str.lastIndexOf("\"");
            boolean hasDatatype = str.contains("^^");
            Pattern pattern = hasLanguage ? languagePattern : (hasDatatype ? dataTypePattern : literalPattern);
            Matcher matcher = pattern.matcher(str);
            if (matcher.find()) {
                if (hasLanguage) {
                    return new Literal(matcher.group(1), matcher.group(2));
                }
                if (hasDatatype) {
                    return new Literal(matcher.group(1), new NamedNode(matcher.group(2)));
                }
                return new Literal(matcher.group(1));
            }
            throw new Error("Invalid Literal: " + str);
        }
        return new NamedNode(str);
    }
}

