/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.records;

import be.ugent.idlab.knows.dataio.access.Access;
import be.ugent.idlab.knows.dataio.iterators.CSVWSourceIterator;
import be.ugent.idlab.knows.dataio.iterators.csvw.CSVWConfiguration;
import be.ugent.idlab.knows.dataio.iterators.csvw.CSVWConfigurationBuilder;
import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.rml.Utils;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.Charsets;

public class CSVW {
    private final QuadStore rmlStore;
    private final Term logicalSource;

    CSVW(QuadStore rmlStore, Term logicalSource) {
        this.rmlStore = rmlStore;
        this.logicalSource = logicalSource;
    }

    List<Record> getRecords(Access access) throws Exception {
        List<Term> sources = Utils.getObjectsFromQuads(this.rmlStore.getQuads(this.logicalSource, new NamedNode("http://w3id.org/rml/source"), null));
        Term source = sources.get(0);
        CSVWConfiguration config = this.getConfiguration(source);
        ArrayList<Record> records = new ArrayList<Record>();
        try (CSVWSourceIterator iterator = new CSVWSourceIterator(access, config);){
            iterator.forEachRemaining(records::add);
        }
        return records;
    }

    private CSVWConfiguration getConfiguration(Term logicalSource) {
        CSVWConfigurationBuilder configBuilder = CSVWConfiguration.builder();
        configBuilder = this.setOptionList(logicalSource, "null", configBuilder, CSVWConfigurationBuilder::withNulls);
        List<Term> dialectTerms = Utils.getObjectsFromQuads(this.rmlStore.getQuads(logicalSource, new NamedNode("http://www.w3.org/ns/csvw#dialect"), null));
        if (!dialectTerms.isEmpty()) {
            Term dialect = dialectTerms.get(0);
            configBuilder = this.setDialectOptions(dialect, configBuilder);
        }
        return configBuilder.build();
    }

    private CSVWConfigurationBuilder setDialectOptions(Term dialect, CSVWConfigurationBuilder configBuilder) {
        configBuilder = this.setOptionString(dialect, "commentPrefix", configBuilder, CSVWConfigurationBuilder::withCommentPrefix);
        configBuilder = this.setOptionChar(dialect, "delimiter", configBuilder, CSVWConfigurationBuilder::withDelimiter);
        configBuilder = this.setOptionChar(dialect, "doubleQuote", configBuilder, CSVWConfigurationBuilder::withEscapeCharacter);
        configBuilder = this.setOptionString(dialect, "trim", configBuilder, CSVWConfigurationBuilder::withTrim);
        configBuilder = this.setOptionChar(dialect, "quoteChar", configBuilder, CSVWConfigurationBuilder::withQuoteCharacter);
        configBuilder = this.setOptionCharset(dialect, "encoding", configBuilder, CSVWConfigurationBuilder::withEncoding);
        return configBuilder;
    }

    private CSVWConfigurationBuilder setOptionString(Term term, String option, CSVWConfigurationBuilder builder, StringOptionSetter setter) {
        List<Term> optionTerms = Utils.getObjectsFromQuads(this.rmlStore.getQuads(term, new NamedNode("http://www.w3.org/ns/csvw#" + option), null));
        if (!optionTerms.isEmpty()) {
            builder = setter.call(builder, optionTerms.get(0).getValue());
        }
        return builder;
    }

    private CSVWConfigurationBuilder setOptionCharset(Term dialect, CSVWConfigurationBuilder builder, CharsetOptionSetter setter) {
        List<Term> optionTerms = Utils.getObjectsFromQuads(this.rmlStore.getQuads(dialect, new NamedNode("http://www.w3.org/ns/csvw#encoding"), null));
        if (!optionTerms.isEmpty()) {
            builder = setter.call(builder, Charset.forName(optionTerms.get(0).getValue()));
        }
        return builder;
    }

    private CSVWConfigurationBuilder setOptionChar(Term term, String option, CSVWConfigurationBuilder builder, CharacterOptionSetter setter) {
        List<Term> optionTerms = Utils.getObjectsFromQuads(this.rmlStore.getQuads(term, new NamedNode("http://www.w3.org/ns/csvw#" + option), null));
        if (!optionTerms.isEmpty()) {
            builder = setter.call(builder, Character.valueOf(optionTerms.get(0).getValue().charAt(0)));
        }
        return builder;
    }

    private CSVWConfigurationBuilder setOptionList(Term term, String option, CSVWConfigurationBuilder builder, ListOptionSetter<String> setter) {
        List<Term> optionTerms = Utils.getObjectsFromQuads(this.rmlStore.getQuads(term, new NamedNode("http://www.w3.org/ns/csvw#" + option), null));
        if (!optionTerms.isEmpty()) {
            List nulls = optionTerms.stream().map(Term::getValue).collect(Collectors.toList());
            builder = setter.call(builder, nulls);
        }
        return builder;
    }

    private CSVWConfigurationBuilder setOptionCharset(Term term, String option, CSVWConfigurationBuilder builder, CharsetOptionSetter setter) {
        List<Term> optionTerms = Utils.getObjectsFromQuads(this.rmlStore.getQuads(term, new NamedNode("http://www.w3.org/ns/csvw#" + option), null));
        if (!optionTerms.isEmpty()) {
            String charsetString = optionTerms.get(0).getValue();
            Charset charset = Charsets.toCharset((String)charsetString);
            builder = setter.call(builder, charset);
        }
        return builder;
    }

    private static interface ListOptionSetter<T> {
        public CSVWConfigurationBuilder call(CSVWConfigurationBuilder var1, List<T> var2);
    }

    private static interface StringOptionSetter {
        public CSVWConfigurationBuilder call(CSVWConfigurationBuilder var1, String var2);
    }

    private static interface CharacterOptionSetter {
        public CSVWConfigurationBuilder call(CSVWConfigurationBuilder var1, Character var2);
    }

    private static interface CharsetOptionSetter {
        public CSVWConfigurationBuilder call(CSVWConfigurationBuilder var1, Charset var2);
    }
}

