/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.functions;

import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.rml.Utils;
import be.ugent.rml.extractor.ConstantExtractor;
import be.ugent.rml.extractor.Extractor;
import be.ugent.rml.extractor.ReferenceExtractor;
import be.ugent.rml.functions.FunctionUtils;
import be.ugent.rml.functions.SingleRecordFunctionExecutor;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcatFunction
implements SingleRecordFunctionExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ConcatFunction.class);
    private boolean encodeURI;
    private List<Extractor> extractors;

    public ConcatFunction(List<Extractor> extractors, boolean encodeURI) {
        this.extractors = extractors;
        this.encodeURI = encodeURI;
    }

    @Override
    public List<?> execute(Record record) {
        return this.concat(record);
    }

    private List<String> concat(Record record) {
        ArrayList<Object> results = new ArrayList<String>();
        results.add("");
        boolean allValuesFound = true;
        int referenceCount = 0;
        StringBuilder onlyConstants = new StringBuilder();
        for (int i = 0; allValuesFound && i < this.extractors.size(); ++i) {
            Extractor extractor = this.extractors.get(i);
            boolean isReferenceExtractor = extractor instanceof ReferenceExtractor;
            boolean isConstantExtractor = extractor instanceof ConstantExtractor;
            List<String> extractedValues = FunctionUtils.functionObjectToList(extractor.extract(record));
            if (!extractedValues.isEmpty()) {
                ArrayList<CallSite> temp = new ArrayList<CallSite>();
                for (String result : results) {
                    for (String value : extractedValues) {
                        if (isReferenceExtractor) {
                            if (this.encodeURI) {
                                value = Utils.encodeURI(value);
                            }
                            ++referenceCount;
                        } else if (isConstantExtractor) {
                            onlyConstants.append(value);
                        }
                        temp.add((CallSite)((Object)(result + value)));
                    }
                }
                results = temp;
            }
            if (!extractedValues.isEmpty()) continue;
            logger.warn("Not all values for a template where found. More specific, the variable {} did not provide any results.", (Object)extractor);
            allValuesFound = false;
        }
        if (!allValuesFound || referenceCount > 0 && results.contains(onlyConstants.toString())) {
            return new ArrayList<String>();
        }
        return results;
    }
}

