/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.extractor;

import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.rml.extractor.Extractor;
import be.ugent.rml.functions.SingleRecordFunctionExecutor;
import java.io.IOException;
import java.util.List;

public class ConstantExtractor
implements Extractor,
SingleRecordFunctionExecutor {
    private final String constant;
    private final List<Object> constantList;
    private final boolean needsEOFMarker;

    public ConstantExtractor(String constant) {
        this.constantList = List.of(constant);
        this.constant = constant;
        this.needsEOFMarker = constant.equals("https://w3id.org/imec/idlab/function#implicitDelete") || constant.equals("http://example.com/idlab/function/implicitDelete");
    }

    @Override
    public List<Object> extract(Record record) {
        return this.constantList;
    }

    @Override
    public Object execute(Record record) throws IOException {
        return this.constant;
    }

    @Override
    public boolean needsEOFMarker() {
        return this.needsEOFMarker;
    }

    public String toString() {
        return "\"" + this.constant + "\"";
    }
}

