/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.conformer;

import be.ugent.rml.Utils;
import be.ugent.rml.conformer.RMLConverterNew;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import java.util.List;
import java.util.Map;

public class MappingConformer {
    private QuadStore store;
    private Map<String, String> mappingOptions;

    public MappingConformer(QuadStore store) throws Exception {
        this(store, null);
    }

    public MappingConformer(QuadStore store, Map<String, String> mappingOptions) throws Exception {
        this.store = store;
        this.mappingOptions = mappingOptions;
    }

    public boolean conform() throws Exception {
        this.detect();
        return false;
    }

    private void detect() throws Exception {
        RMLConverterNew converter = new RMLConverterNew(this.store);
        converter.convert(this.mappingOptions);
        List<Term> triplesMaps = Utils.getSubjectsFromQuads(this.store.getQuads(null, new NamedNode("http://w3id.org/rml/logicalSource"), null));
        if (triplesMaps.isEmpty()) {
            throw new Exception("Mapping requires at least one TriplesMap");
        }
        List<Term> triplesMaps2 = Utils.getSubjectsFromQuads(this.store.getQuads(null, null, new NamedNode("http://w3id.org/rml/TriplesMap")));
        for (Term triplesMap : triplesMaps2) {
            if (this.store.contains(triplesMap, new NamedNode("http://w3id.org/rml/subjectMap"), null)) continue;
            throw new Exception("TriplesMap requires a subject map");
        }
    }

    boolean differenceInConformer(QuadStore store) {
        return this.store.isSubset(store);
    }

    boolean differenceInGivenStore(QuadStore store) {
        return store.isSubset(this.store);
    }

    public QuadStore getStore() {
        return this.store;
    }

    public static enum Dialect {
        RML,
        R2RML,
        RML2;

    }
}

