/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.term;

import be.ugent.rml.term.AbstractTerm;
import be.ugent.rml.term.Term;

public class Literal
extends AbstractTerm {
    private String language;
    private Term datatype;

    public Literal(String value) {
        super(value);
    }

    public Literal(String value, String language) {
        this(value);
        this.language = language;
    }

    public Literal(String value, Term datatype) {
        this(value);
        this.datatype = datatype;
    }

    public String getLanguage() {
        return this.language;
    }

    public Term getDatatype() {
        return this.datatype;
    }

    @Override
    public String toString() {
        String temp = "\"" + this.escapeValue(this.getValue()) + "\"";
        if (this.language != null && !this.language.equals("")) {
            temp = temp + "@" + this.language;
        } else if (this.datatype != null && !this.datatype.getValue().equals("http://www.w3.org/2001/XMLSchema#string")) {
            temp = temp + "^^" + this.datatype;
        }
        return temp;
    }

    public boolean equals(Object o) {
        if (o instanceof Literal) {
            return o.toString().equals(this.toString());
        }
        return false;
    }

    private String escapeValue(String label) {
        Object result = "";
        for (int i = 0; i < label.length(); ++i) {
            char c = label.charAt(i);
            result = c == '\\' ? (String)result + "\\\\" : (c == '\"' ? (String)result + "\\\"" : (c == '\n' ? (String)result + "\\n" : (c == '\r' ? (String)result + "\\r" : (c == '\t' ? (String)result + "\\t" : (String)result + c))));
        }
        return result;
    }
}

