/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.target;

import be.ugent.rml.Utils;
import be.ugent.rml.store.Quad;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.target.LocalFileTarget;
import be.ugent.rml.target.SPARQLEndpointTarget;
import be.ugent.rml.target.Target;
import be.ugent.rml.term.Literal;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetFactory {
    private final String basePath;
    private static final Logger logger = LoggerFactory.getLogger(TargetFactory.class);

    public TargetFactory(String basePath) {
        this.basePath = basePath;
    }

    public Target getTarget(Term logicalTarget, QuadStore rmlStore, QuadStore outputStore) throws NotImplementedException, IOException {
        Target target = null;
        String serializationFormat = "nquads";
        String compression = null;
        ArrayList<Quad> metadata = new ArrayList<Quad>();
        if (logicalTarget instanceof Literal) {
            logger.warn("Legacy string output path for Target found, do not use, this is only supported for backwards compatibility reasons.");
            String location = logicalTarget.getValue();
            if (location.endsWith(".nq")) {
                serializationFormat = "nquads";
            } else if (location.endsWith(".nt")) {
                serializationFormat = "ntriples";
            } else if (location.endsWith(".ttl")) {
                serializationFormat = "turtle";
            } else if (location.endsWith(".jsonld")) {
                serializationFormat = "jsonld";
            } else {
                throw new NotImplementedException("Serialization format for " + location + " not implemented!");
            }
            target = new LocalFileTarget(location, this.basePath, serializationFormat, null, metadata);
            return target;
        }
        List<Term> targets = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalTarget, new NamedNode("http://semweb.mmlab.be/ns/rml-target#target"), null));
        try {
            String sf = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalTarget, new NamedNode("http://semweb.mmlab.be/ns/rml-target#serialization"), null)).get(0).getValue();
            switch (sf) {
                case "http://www.w3.org/ns/formats/N-Triples": {
                    serializationFormat = "ntriples";
                    break;
                }
                case "http://www.w3.org/ns/formats/N-Quads": {
                    serializationFormat = "nquads";
                    break;
                }
                case "http://www.w3.org/ns/formats/JSON-LD": {
                    serializationFormat = "jsonld";
                    break;
                }
                case "http://www.w3.org/ns/formats/Turtle": {
                    serializationFormat = "turtle";
                    break;
                }
                default: {
                    throw new NotImplementedException("Serialization format " + sf + " not implemented!");
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            logger.debug("No serialization format specified, falling back to default N-Quads");
        }
        try {
            Term comp = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalTarget, new NamedNode("http://semweb.mmlab.be/ns/rml-target#compression"), null)).get(0);
            switch (comp.getValue()) {
                case "http://semweb.mmlab.be/ns/rml-compression#gzip": {
                    compression = "gzip";
                    break;
                }
                case "http://semweb.mmlab.be/ns/rml-compression#zip": {
                    compression = "zip";
                    break;
                }
                default: {
                    throw new NotImplementedException("Compression " + comp + " is not implemented!");
                }
            }
            logger.debug("Compression: {}", (Object)compression);
        }
        catch (IndexOutOfBoundsException e) {
            logger.debug("Compression disabled");
        }
        List<Term> types = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalTarget, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), null));
        for (Term type : types) {
            NamedNode eventstream_iri;
            if (!type.getValue().equals("https://w3id.org/ldes#EventStreamTarget")) continue;
            logger.debug("Found LDES EventStreamTarget");
            Term versionOfPathObj = null;
            Term timestampPathObj = null;
            try {
                Term iri = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalTarget, new NamedNode("https://w3id.org/ldes#baseIRI"), null)).get(0);
                eventstream_iri = new NamedNode(iri.getValue());
                logger.debug("LDES base IRI: {}", (Object)iri.getValue());
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("No base IRI specified for LDES!");
            }
            try {
                Term shape = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalTarget, new NamedNode("https://w3id.org/tree#shape"), null)).get(0);
                logger.debug("SHACL shape: {}", (Object)shape.getValue());
                metadata.add(new Quad(eventstream_iri, new NamedNode("https://w3id.org/tree#shape"), shape));
            }
            catch (IndexOutOfBoundsException e) {
                logger.debug("No SHACL shape specified for LDES.");
            }
            metadata.add(new Quad(eventstream_iri, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), new NamedNode("https://w3id.org/ldes#EventStream")));
            ArrayList<Term> subjects = new ArrayList<Term>(new HashSet<Term>(Utils.getSubjectsFromQuads(outputStore.getQuads(null, null, null))));
            for (Term s : subjects) {
                metadata.add(new Quad(eventstream_iri, new NamedNode("https://w3id.org/tree#member"), s));
            }
            try {
                versionOfPathObj = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalTarget, new NamedNode("https://w3id.org/ldes#versionOfPath"), null)).get(0);
                metadata.add(new Quad(eventstream_iri, new NamedNode("https://w3id.org/ldes#versionOfPath"), versionOfPathObj));
            }
            catch (IndexOutOfBoundsException e) {
                logger.debug("No versionOfPath found");
            }
            try {
                timestampPathObj = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalTarget, new NamedNode("https://w3id.org/ldes#timestampPath"), null)).get(0);
                metadata.add(new Quad(eventstream_iri, new NamedNode("https://w3id.org/ldes#timestampPath"), timestampPathObj));
            }
            catch (IndexOutOfBoundsException e) {
                logger.debug("No timestampPath found");
            }
            break;
        }
        if (!targets.isEmpty()) {
            Term t = targets.get(0);
            logger.debug("getTarget() for {}", (Object)t.toString());
            String targetType = Utils.getObjectsFromQuads(rmlStore.getQuads(t, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), null)).get(0).getValue();
            logger.debug("Target is IRI, target type: {}", (Object)targetType);
            switch (targetType) {
                case "http://rdfs.org/ns/void#Dataset": {
                    logger.debug("Target is a VoID Dataset");
                    String location = Utils.getObjectsFromQuads(rmlStore.getQuads(t, new NamedNode("http://rdfs.org/ns/void#dataDump"), null)).get(0).getValue();
                    location = location.replace("file://", "");
                    logger.debug("VoID datadump location: {}", (Object)location);
                    target = new LocalFileTarget(location, this.basePath, serializationFormat, compression, metadata);
                    break;
                }
                case "http://www.w3.org/ns/dcat#Dataset": {
                    logger.debug("Target is a DCAT Dataset");
                    String location = Utils.getObjectsFromQuads(rmlStore.getQuads(t, new NamedNode("http://www.w3.org/ns/dcat#dataDump"), null)).get(0).getValue();
                    location = location.replace("file://", "");
                    logger.debug("DCAT datadump location: {}", (Object)location);
                    target = new LocalFileTarget(location, this.basePath, serializationFormat, compression, metadata);
                    break;
                }
                case "http://www.w3.org/ns/sparql-service-description#Service": {
                    logger.debug("Target is a SD Service");
                    String endpoint = Utils.getObjectsFromQuads(rmlStore.getQuads(t, new NamedNode("http://www.w3.org/ns/sparql-service-description#endpoint"), null)).get(0).getValue();
                    String supportedLanguage = Utils.getObjectsFromQuads(rmlStore.getQuads(t, new NamedNode("http://www.w3.org/ns/sparql-service-description#supportedLanguage"), null)).get(0).getValue();
                    logger.debug("SPARQL Service endpoint: {}", (Object)endpoint);
                    logger.debug("SPARQL Service supported language: {}", (Object)supportedLanguage);
                    if (!supportedLanguage.equals("http://www.w3.org/ns/sparql-service-description#SPARQL11Update")) {
                        throw new IllegalArgumentException("SPARQL Service target must support SPARQL Update!");
                    }
                    target = new SPARQLEndpointTarget(endpoint, metadata);
                    break;
                }
                default: {
                    throw new NotImplementedException("Not implemented");
                }
            }
            logger.debug("Target created: {}", (Object)target);
            return target;
        }
        throw new Error("The Target does not have target.");
    }
}

