/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.records;

import be.ugent.rml.Utils;
import be.ugent.rml.access.Access;
import be.ugent.rml.access.AccessFactory;
import be.ugent.rml.records.CSVRecordFactory;
import be.ugent.rml.records.HTMLRecordFactory;
import be.ugent.rml.records.JSONRecordFactory;
import be.ugent.rml.records.Record;
import be.ugent.rml.records.ReferenceFormulation;
import be.ugent.rml.records.ReferenceFormulationRecordFactory;
import be.ugent.rml.records.XMLRecordFactory;
import be.ugent.rml.store.Quad;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordsFactory {
    private Map<Access, Map<String, Map<String, List<Record>>>> recordCache;
    private AccessFactory accessFactory;
    private Map<String, ReferenceFormulationRecordFactory> referenceFormulationRecordFactoryMap;
    private static final Logger logger = LoggerFactory.getLogger(RecordsFactory.class);

    public RecordsFactory(String basePath) {
        this.accessFactory = new AccessFactory(basePath);
        this.recordCache = new HashMap<Access, Map<String, Map<String, List<Record>>>>();
        this.referenceFormulationRecordFactoryMap = new HashMap<String, ReferenceFormulationRecordFactory>();
        this.referenceFormulationRecordFactoryMap.put(ReferenceFormulation.XPath, new XMLRecordFactory());
        this.referenceFormulationRecordFactoryMap.put(ReferenceFormulation.JSONPath, new JSONRecordFactory());
        this.referenceFormulationRecordFactoryMap.put(ReferenceFormulation.CSV, new CSVRecordFactory());
        this.referenceFormulationRecordFactoryMap.put(ReferenceFormulation.RDB, new CSVRecordFactory());
        this.referenceFormulationRecordFactoryMap.put(ReferenceFormulation.CSS3, new HTMLRecordFactory());
    }

    public List<Record> createRecords(Term triplesMap, QuadStore rmlStore) throws Exception {
        List<Term> logicalSources = Utils.getObjectsFromQuads(rmlStore.getQuads(triplesMap, new NamedNode("http://semweb.mmlab.be/ns/rml#logicalSource"), null));
        if (!logicalSources.isEmpty()) {
            Term logicalSource = logicalSources.get(0);
            Access access = this.accessFactory.getAccess(logicalSource, rmlStore);
            List<Term> referenceFormulations = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalSource, new NamedNode("http://semweb.mmlab.be/ns/rml#referenceFormulation"), null));
            List<Term> tables = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalSource, new NamedNode("http://www.w3.org/ns/r2rml#tableName"), null));
            if (referenceFormulations.isEmpty() && !tables.isEmpty()) {
                referenceFormulations = new ArrayList<Term>();
                referenceFormulations.add(0, new NamedNode(ReferenceFormulation.RDB));
            }
            if (referenceFormulations.isEmpty()) {
                throw new Error("The Logical Source of " + triplesMap + " does not have a reference formulation.");
            }
            String referenceFormulation = referenceFormulations.get(0).getValue();
            return this.getRecords(access, logicalSource, referenceFormulation, rmlStore);
        }
        throw new Error("No Logical Source is found for " + triplesMap + ". Exactly one Logical Source is required per Triples Map.");
    }

    private List<Record> getRecordsFromCache(Access access, String referenceFormulation, String hash) {
        if (this.recordCache.containsKey(access) && this.recordCache.get(access).containsKey(referenceFormulation) && this.recordCache.get(access).get(referenceFormulation).containsKey(hash)) {
            return this.recordCache.get(access).get(referenceFormulation).get(hash);
        }
        return null;
    }

    private void putRecordsIntoCache(Access access, String referenceFormulation, String hash, List<Record> records) {
        if (!this.recordCache.containsKey(access)) {
            this.recordCache.put(access, new HashMap());
        }
        if (!this.recordCache.get(access).containsKey(referenceFormulation)) {
            this.recordCache.get(access).put(referenceFormulation, new HashMap());
        }
        this.recordCache.get(access).get(referenceFormulation).put(hash, records);
    }

    private List<Record> getRecords(Access access, Term logicalSource, String referenceFormulation, QuadStore rmlStore) throws Exception {
        String logicalSourceHash = this.hashLogicalSource(logicalSource, rmlStore);
        List<Record> records = this.getRecordsFromCache(access, referenceFormulation, logicalSourceHash);
        if (records == null) {
            if (!this.referenceFormulationRecordFactoryMap.containsKey(referenceFormulation)) {
                logger.error("Referenceformulation {} is unsupported!", (Object)referenceFormulation);
            }
            ReferenceFormulationRecordFactory factory = this.referenceFormulationRecordFactoryMap.get(referenceFormulation);
            records = factory.getRecords(access, logicalSource, rmlStore);
            this.putRecordsIntoCache(access, referenceFormulation, logicalSourceHash, records);
            return records;
        }
        return records;
    }

    private String hashLogicalSource(Term logicalSource, QuadStore rmlStore) {
        List<Quad> quads = rmlStore.getQuads(logicalSource, null, null);
        String[] hash = new String[]{""};
        quads.forEach(quad -> {
            if (!quad.getPredicate().getValue().equals("http://semweb.mmlab.be/ns/rml#source") && !quad.getPredicate().getValue().equals("http://semweb.mmlab.be/ns/rml#referenceFormulation")) {
                hash[0] = hash[0] + quad.getObject().getValue();
            }
        });
        return hash[0];
    }
}

