/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.records;

import be.ugent.rml.records.Record;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.Row;

public class ODSRecord
extends Record {
    private Row row;
    private Map<String, Cell> header = new HashMap<String, Cell>();

    public ODSRecord(Row header, Row row) {
        Row nextRow = header.getNextRow();
        for (int i = 0; i < header.getCellCount(); ++i) {
            Cell cell = header.getCellByIndex(i);
            this.header.put(cell.getStringValue(), nextRow.getCellByIndex(i));
        }
        this.row = row;
    }

    @Override
    public String getDataType(String value) {
        String cellType = null;
        if (this.header != null && this.header.get(value) != null) {
            cellType = this.header.get(value).getValueType();
        }
        return ODSRecord.getIRI(cellType);
    }

    @Override
    public List<Object> get(String value) {
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            Object obj;
            int index = this.header.get(value).getColumnIndex();
            Cell cell = this.row.getCellByIndex(index);
            switch (cell.getValueType()) {
                case "boolean": {
                    obj = cell.getBooleanValue();
                    break;
                }
                case "float": {
                    double d = cell.getDoubleValue();
                    if (d % 1.0 == 0.0) {
                        obj = (int)d;
                        break;
                    }
                    obj = d;
                    break;
                }
                default: {
                    obj = cell.getStringValue();
                }
            }
            obj = String.valueOf(obj);
            result.add(obj);
        }
        catch (Exception e) {
            return result;
        }
        return result;
    }

    public static String getIRI(String cellType) {
        if (cellType == null) {
            return "";
        }
        switch (cellType) {
            default: 
        }
        return XSDDatatype.XSDstring.getURI();
    }
}

