/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.records;

import be.ugent.rml.records.Record;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CSVRecord
extends Record {
    private Map<String, String> data = new HashMap<String, String>();
    private Map<String, String> datatypes;

    CSVRecord(String[] header, String[] data, Map<String, String> datatypes) {
        for (int i = 0; i < header.length; ++i) {
            this.data.put(header[i], data[i]);
        }
        this.datatypes = datatypes;
    }

    @Override
    public String getDataType(String value) {
        String datatype = null;
        if (this.datatypes != null && (datatype = this.datatypes.get(value)) == null) {
            value = value.replaceFirst("^\"", "").replaceFirst("\"$", "");
            value = value.replaceFirst("^'", "").replaceFirst("'$", "");
            datatype = this.datatypes.get(value);
        }
        return datatype;
    }

    @Override
    public List<Object> get(String value) {
        String toDatabaseCase = this.data.containsKey(value.toUpperCase()) ? value.toUpperCase() : (this.data.containsKey(value.toLowerCase()) ? value.toLowerCase() : value);
        if (!this.data.containsKey(toDatabaseCase)) {
            throw new IllegalArgumentException(String.format("Mapping for %s not found, expected one of %s", toDatabaseCase, this.data.keySet()));
        }
        ArrayList<Object> result = new ArrayList<Object>();
        String obj = this.data.get(toDatabaseCase);
        if (obj != null) {
            result.add(obj);
        }
        return result;
    }

    public Map<String, String> getData() {
        return this.data;
    }
}

