/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.access;

import be.ugent.rml.Utils;
import be.ugent.rml.access.Access;
import com.jayway.jsonpath.Configuration;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WoTAccess
implements Access {
    private static final Logger logger = LoggerFactory.getLogger(WoTAccess.class);
    private final HashMap<String, HashMap<String, String>> auth;
    private String location;
    private String contentType;
    private HashMap<String, String> headers;

    public WoTAccess(String location, String contentType, HashMap<String, String> headers, HashMap<String, HashMap<String, String>> auth) {
        this.location = location;
        this.contentType = contentType;
        this.headers = headers;
        this.auth = auth;
        logger.debug("Created WoTAccess:\n\tlocation: {}\n\tcontent-type: {}", (Object)this.location, (Object)this.contentType);
        logger.debug(headers.toString());
        headers.forEach((name, value) -> logger.debug("Header: {} : {}", name, value));
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream response;
        logger.debug("get inputstream");
        if (this.auth.get("data").containsKey("refresh")) {
            try {
                response = Utils.getInputStreamFromAuthURL(new URL(this.location), this.contentType, this.headers);
            }
            catch (Exception e) {
                logger.debug("Refresh token");
                this.refreshToken();
                logger.debug("try again with new token");
                logger.debug("new token = {}", (Object)this.headers.get(this.auth.get("info").get("name")));
                return Utils.getInputStreamFromURL(new URL(this.location), this.contentType, this.headers);
            }
        } else {
            response = Utils.getInputStreamFromURL(new URL(this.location), this.contentType, this.headers);
        }
        return response;
    }

    @Override
    public Map<String, String> getDataTypes() {
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof WoTAccess) {
            WoTAccess access = (WoTAccess)o;
            return this.location.equals(access.getLocation()) && this.contentType.equals(access.getContentType());
        }
        return false;
    }

    public int hashCode() {
        return Utils.getHashOfString(this.getLocation() + this.getContentType());
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public void refreshToken() throws MalformedURLException {
        StringBuilder data = new StringBuilder();
        data.append("{\"grant_type\": \"refresh_token\"");
        for (String name : this.auth.get("data").keySet()) {
            data.append(" ,\"").append(name).append("\":\"").append(this.auth.get("data").get(name)).append("\"");
        }
        data.append("}");
        logger.debug(data.toString());
        InputStream response = Utils.getPostRequestResponse(new URL(this.auth.get("info").get("authorization")), this.contentType, data.toString().getBytes());
        HashMap jsonResponse = (HashMap)Configuration.defaultConfiguration().jsonProvider().parse(response, "utf-8");
        this.headers.put(this.auth.get("info").get("name"), "Bearer " + (String)jsonResponse.get("access_token"));
    }
}

