/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.functions.agent.functionModelProvider.fno;

import be.ugent.idlab.knows.functions.agent.dataType.DataTypeConverter;
import be.ugent.idlab.knows.functions.agent.dataType.DataTypeConverterProvider;
import be.ugent.idlab.knows.functions.agent.dataType.ListConverter;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.FunctionModelProvider;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.NAMESPACES;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.AppliesNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.ClassNameDescriptionNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.CompositionEndPointNotFound;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.CompositionStartingPointNotFound;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.ConstituentFunctionNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.DataTypeNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.FnODocNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.FnOException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.FunctionMappingNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.FunctionNameNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.FunctionNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.ImplementationDescriptionNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.LiteralNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.MappingParameterNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.MethodMappingNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.MethodMappingTypeNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.MethodNameNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.ParameterNameDescriptionNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.ParameterNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.ParameterPredicateNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.PartialFunctionApplicationException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.UnsupportedImplementationTypeException;
import be.ugent.idlab.knows.functions.agent.model.CompositionMappingElement;
import be.ugent.idlab.knows.functions.agent.model.CompositionMappingPoint;
import be.ugent.idlab.knows.functions.agent.model.Function;
import be.ugent.idlab.knows.functions.agent.model.FunctionComposition;
import be.ugent.idlab.knows.functions.agent.model.FunctionMapping;
import be.ugent.idlab.knows.functions.agent.model.Implementation;
import be.ugent.idlab.knows.functions.agent.model.MethodMapping;
import be.ugent.idlab.knows.functions.agent.model.Parameter;
import be.ugent.idlab.knows.misc.FileFinder;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FnOFunctionModelProvider
implements FunctionModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(FnOFunctionModelProvider.class);
    private final Model functionDescriptionTriples = ModelFactory.createDefaultModel();
    private final Map<String, Function> functionId2Functions = new HashMap<String, Function>();
    private final Map<String, FunctionMapping> functionId2functionMappings = new HashMap<String, FunctionMapping>();
    private final Map<String, FunctionComposition> functionId2functionCompositions = new HashMap<String, FunctionComposition>();
    private final DataTypeConverterProvider dataTypeConverterProvider;
    private final Map<String, String> location2otherLocationMap;
    private final Map<String, String> parameterURItoPredicate = new HashMap<String, String>();
    private final Property typeProperty = ResourceFactory.createProperty((String)NAMESPACES.RDF.toString(), (String)"type");

    public FnOFunctionModelProvider(DataTypeConverterProvider dataTypeConverterProvider, String ... fnoDocPaths) throws FnOException {
        this(dataTypeConverterProvider, Collections.emptyMap(), fnoDocPaths);
    }

    public FnOFunctionModelProvider(DataTypeConverterProvider dataTypeConverterProvider, Map<String, String> implementationLocationMapping, String ... fnoDocPaths) throws FnOException {
        this.dataTypeConverterProvider = dataTypeConverterProvider;
        this.location2otherLocationMap = implementationLocationMapping;
        this.parse(fnoDocPaths);
    }

    @Override
    public Map<String, Function> getFunctions() {
        return this.functionId2Functions;
    }

    private void parse(String ... fnoDocPaths) throws FnOException {
        logger.info("Loading function descriptions from {}", (Object)Arrays.toString(fnoDocPaths));
        try {
            this.readRDFModel(fnoDocPaths);
            this.parseFunctionMappings();
            this.parseParameterPredicateMappings();
            this.parseFunctionCompositions();
            this.parseFunctions();
            this.mapFunctionMappingsAndCompositionsToFunctions();
            this.parsePartialApplications();
            this.parseApplies();
        }
        finally {
            this.functionDescriptionTriples.close();
            this.functionId2functionMappings.clear();
            this.functionId2functionCompositions.clear();
            this.parameterURItoPredicate.clear();
        }
    }

    private void readRDFModel(String ... fnoDocPaths) throws FnODocNotFoundException {
        for (String fnoDocPath : fnoDocPaths) {
            logger.debug("Reading RDF model from {}", (Object)fnoDocPath);
            URL fnoDocURL = FileFinder.findFile(fnoDocPath);
            if (fnoDocURL != null) {
                logger.debug("'{}' resolved to '{}'", (Object)fnoDocPath, (Object)fnoDocURL);
                RDFDataMgr.read((Model)this.functionDescriptionTriples, (String)fnoDocPath, (Lang)Lang.TURTLE);
                continue;
            }
            logger.warn("Could not find document; trying to interpret it as direct Turtle input.");
            try {
                RDFDataMgr.read((Model)this.functionDescriptionTriples, (StringReader)new StringReader(fnoDocPath), (String)"", (Lang)Lang.TURTLE);
            }
            catch (Throwable t) {
                throw new FnODocNotFoundException("Could not process FnO document: " + t.getMessage());
            }
        }
    }

    private void mapFunctionMappingsAndCompositionsToFunctions() throws FunctionMappingNotFoundException {
        for (String functionId : this.functionId2Functions.keySet()) {
            Function function;
            logger.debug("Finding mapping for function {}", (Object)functionId);
            if (this.functionId2functionMappings.containsKey(functionId)) {
                function = this.functionId2Functions.get(functionId);
                function.setFunctionMapping(this.functionId2functionMappings.get(functionId));
                continue;
            }
            if (this.functionId2functionCompositions.containsKey(functionId)) {
                logger.debug("Composition found for " + functionId);
                function = this.functionId2Functions.get(functionId);
                function.setComposite(true);
                function.setFunctionComposition(this.functionId2functionCompositions.get(functionId));
                continue;
            }
            throw new FunctionMappingNotFoundException("No '" + NAMESPACES.FNO + "Mapping' or '" + NAMESPACES.FNOC + "Composition' found for function '" + functionId + "\"");
        }
    }

    private void parseFunctionMappings() throws FnOException {
        logger.debug("Parsing function mappings");
        Resource functionMappingObject = ResourceFactory.createResource((String)(NAMESPACES.FNO + "Mapping"));
        ResIterator mappings = this.functionDescriptionTriples.listSubjectsWithProperty(this.typeProperty, (RDFNode)functionMappingObject);
        while (mappings.hasNext()) {
            this.parseFunctionMapping(mappings.nextResource());
        }
    }

    private void parseParameterPredicateMappings() throws ParameterPredicateNotFoundException {
        logger.debug("Parsing parameter URI to predicate");
        Property parameterPredicateObject = ResourceFactory.createProperty((String)(NAMESPACES.FNO + "predicate"));
        ResIterator parameters = this.functionDescriptionTriples.listSubjectsWithProperty(parameterPredicateObject);
        while (parameters.hasNext()) {
            this.parseParameterPredicateMapping(parameters.nextResource());
        }
    }

    private void parseParameterPredicateMapping(Resource parameter) throws ParameterPredicateNotFoundException {
        String predicateURI = this.getObjectURI(parameter, NAMESPACES.FNO + "predicate").orElseThrow(() -> new ParameterPredicateNotFoundException("Could not find " + NAMESPACES.FNO + "predicate value for parameter " + parameter.getLocalName()));
        this.parameterURItoPredicate.put(parameter.getURI(), predicateURI);
    }

    private void parseFunctionCompositions() throws FnOException {
        logger.debug("Parsing function compositions");
        Resource functionCompositionObject = ResourceFactory.createResource((String)(NAMESPACES.FNOC + "Composition"));
        ResIterator mappings = this.functionDescriptionTriples.listSubjectsWithProperty(this.typeProperty, (RDFNode)functionCompositionObject);
        while (mappings.hasNext()) {
            this.parseFunctionComposition(mappings.nextResource());
        }
    }

    private void parsePartialApplications() throws FnOException {
        logger.debug("Parsing partial function applications");
        Property partialApplicationObject = ResourceFactory.createProperty((String)(NAMESPACES.FNOC + "PartiallyAppliedFunction"));
        ResIterator applications = this.functionDescriptionTriples.listSubjectsWithProperty(this.typeProperty, (RDFNode)partialApplicationObject);
        while (applications.hasNext()) {
            this.parsePartialApplication(applications.nextResource());
        }
    }

    private void parsePartialApplication(Resource resource) throws FnOException {
        CompositionMappingElement element;
        CompositionMappingPoint to;
        CompositionMappingPoint from;
        logger.debug("parsing partial application for function {}", (Object)resource.getURI());
        String functionId = resource.getURI();
        Resource originalFunction = this.getObjectResource(resource, NAMESPACES.FNOC + "partiallyApplies").orElseThrow(() -> new FunctionNotFoundException("no function found to partially apply in partial application with id: " + functionId));
        Function original = this.functionId2Functions.get(originalFunction.getURI());
        if (original == null) {
            throw new FunctionNotFoundException("function to partially apply with id " + originalFunction.getURI() + " not found");
        }
        FunctionComposition composition = new FunctionComposition();
        composition.setFunctionId(functionId);
        List<Resource> mappings = this.getObjectResources(resource, NAMESPACES.FNOC + "parameterBinding");
        if (mappings.isEmpty()) {
            logger.debug("No mapping found in partial function application, treating it as {}:applies", (Object)NAMESPACES.FNOC);
            this.functionId2Functions.put(functionId, original);
            return;
        }
        ArrayList<String> parametersToRemove = new ArrayList<String>();
        for (Resource resource2 : mappings) {
            Literal term = this.getLiteral(resource2, NAMESPACES.FNOC + "boundToTerm").orElseThrow(() -> new LiteralNotFoundException("No literal found for partial application for " + functionId));
            String parameterURI = this.getObjectURI(resource2, NAMESPACES.FNOC + "boundParameter").orElseThrow(() -> new ParameterNotFoundException("No parameter found for partial application for " + functionId));
            String parameterPredicate = this.parameterURItoPredicate.get(parameterURI);
            if (parameterPredicate == null) {
                throw new ParameterNotFoundException("Predicate of provided parameter " + parameterURI + " of function " + originalFunction.getURI() + " not found");
            }
            parametersToRemove.add(parameterPredicate);
            CompositionMappingPoint from2 = new CompositionMappingPoint("", term.getString(), false);
            from2.setLiteral(true);
            CompositionMappingPoint to2 = new CompositionMappingPoint(originalFunction.getURI(), parameterPredicate, false);
            CompositionMappingElement element2 = new CompositionMappingElement(from2, to2);
            composition.addMapping(element2);
        }
        List<Parameter> newParameters = original.getArgumentParameters();
        for (String s : parametersToRemove) {
            if (!newParameters.stream().map(Parameter::getId).noneMatch(id -> Objects.equals(id, s))) continue;
            throw new PartialFunctionApplicationException("Provided parameter: " + s + " not found in original functions parameters.");
        }
        newParameters = newParameters.stream().filter(p -> !parametersToRemove.contains(p.getId())).collect(Collectors.toList());
        for (Parameter p2 : newParameters) {
            from = new CompositionMappingPoint(functionId, p2.getId(), false);
            to = new CompositionMappingPoint(originalFunction.getURI(), p2.getId(), false);
            element = new CompositionMappingElement(from, to);
            composition.addMapping(element);
        }
        for (Parameter p2 : original.getReturnParameters()) {
            from = new CompositionMappingPoint(originalFunction.getURI(), p2.getId(), true);
            to = new CompositionMappingPoint(functionId, p2.getId(), false);
            element = new CompositionMappingElement(from, to);
            composition.addMapping(element);
        }
        Function function = new Function(functionId, original.getId(), original.getDescription(), newParameters, original.getReturnParameters());
        this.functionId2Functions.put(functionId, function);
        function.setComposite(true);
        function.setFunctionComposition(composition);
    }

    private void parseFunctionMapping(Resource functionMappingResource) throws FnOException {
        logger.debug("Parsing function mapping {}", (Object)functionMappingResource.getURI());
        String functionURI = this.getObjectURI(functionMappingResource, NAMESPACES.FNO + "function").orElseThrow(() -> new FunctionNotFoundException("No function resource found for fno:Mapping '" + functionMappingResource.getURI() + "'"));
        if (!this.functionId2functionMappings.containsKey(functionURI)) {
            String functionMappingURI = functionMappingResource.getURI();
            logger.debug("Parsing function mapping {} for function {}", (Object)functionMappingURI, (Object)functionURI);
            MethodMapping methodMapping = this.parseMethodMapping(functionMappingResource);
            Implementation implementation = this.parseImplementation(functionMappingResource);
            FunctionMapping functionMapping = new FunctionMapping(functionURI, methodMapping, implementation);
            this.functionId2functionMappings.put(functionURI, functionMapping);
        } else {
            logger.debug("Function mapping for {} already parsed", (Object)functionURI);
        }
    }

    private void parseFunctionComposition(Resource functionCompositionResource) throws FnOException {
        logger.debug("Parsing function Composition {}", (Object)functionCompositionResource.getURI());
        FunctionComposition composition = new FunctionComposition();
        List<Resource> mappings = this.getObjectResources(functionCompositionResource, NAMESPACES.FNOC + "composedOf");
        for (Resource r : mappings) {
            CompositionMappingElement point = this.parseCompositionMapElement(r);
            if (point.getTo().isOutput()) {
                composition.setFunctionId(point.getTo().getFunctionId());
            }
            if (composition.addMapping(point)) continue;
            logger.debug("duplicate mapping rule found for {}", (Object)functionCompositionResource.getURI());
        }
        this.functionId2functionCompositions.put(composition.getFunctionId(), composition);
    }

    private MethodMapping parseMethodMapping(Resource functionMappingResource) throws FnOException {
        logger.debug("Parsing method mapping for {}", (Object)functionMappingResource.getURI());
        Resource methodMappingResource = this.getObjectResource(functionMappingResource, NAMESPACES.FNO + "methodMapping").orElseThrow(() -> new MethodMappingNotFoundException("No '" + NAMESPACES.FNO + "methodMapping' found for fno:Mapping '" + functionMappingResource.getURI() + "'"));
        String methodMappingType = this.getObjectURI(methodMappingResource, this.typeProperty.getURI()).orElseThrow(() -> new MethodMappingTypeNotFoundException("No type of method mapping found for fno:Mapping '" + functionMappingResource.getURI() + "'"));
        String methodName = this.getLiteralStr(methodMappingResource, NAMESPACES.FNOM + "method-name").orElseThrow(() -> new MethodNameNotFoundException("No '" + NAMESPACES.FNOM + "method-name' found for fno:Mapping '" + functionMappingResource.getURI() + "' "));
        return new MethodMapping(methodMappingType, methodName);
    }

    private Implementation parseImplementation(Resource functionMappingResource) throws FnOException {
        logger.debug("Parsing implementation for {}", (Object)functionMappingResource.getURI());
        Optional<Resource> implementationResourceOption = this.getObjectResource(functionMappingResource, NAMESPACES.FNO + "implementation");
        Resource implementationResource = implementationResourceOption.orElseThrow(() -> new ImplementationDescriptionNotFoundException("No implementation found for function mapping " + functionMappingResource.getURI()));
        String implementationUri = implementationResource.getURI();
        String implementationType = this.getObjectURI(implementationResource, this.typeProperty.getURI()).orElseThrow(() -> new ImplementationDescriptionNotFoundException("No implementation type found for implementation resource " + implementationUri));
        String supportedImplementationType = NAMESPACES.FNOI + "JavaClass";
        if (!implementationType.equals(supportedImplementationType)) {
            throw new UnsupportedImplementationTypeException("Only implementation type '" + supportedImplementationType + "' supported. Found '" + implementationType + "'");
        }
        String className = this.getLiteralStr(implementationResource, NAMESPACES.FNOI + "class-name").orElseThrow(() -> new ClassNameDescriptionNotFoundException("No '" + NAMESPACES.FNOI + "class-name' found for implementation '" + implementationUri + "'"));
        Property downloadPageProperty = ResourceFactory.createProperty((String)NAMESPACES.DOAP.toString(), (String)"download-page");
        String location = this.getLiteralStr(implementationResource, downloadPageProperty.getURI()).orElse("");
        String mappedLocation = this.location2otherLocationMap.getOrDefault(location, location);
        return new Implementation(className, mappedLocation);
    }

    private CompositionMappingElement parseCompositionMapElement(Resource compositionMapElementResource) throws FnOException {
        CompositionMappingPoint startingPoint = this.parseCompositionMapElementStartingpoint(compositionMapElementResource);
        CompositionMappingPoint endPoint = this.parseCompositionMapElementEndpoint(compositionMapElementResource);
        return new CompositionMappingElement(startingPoint, endPoint);
    }

    private CompositionMappingPoint parseCompositionMapElementStartingpoint(Resource element) throws FnOException {
        Optional<Resource> startingPointResource = this.getObjectResource(element, NAMESPACES.FNOC + "mapFrom");
        if (startingPointResource.isPresent()) {
            Resource startingPointFunction = this.getObjectResource(startingPointResource.get(), NAMESPACES.FNOC + "constituentFunction").orElseThrow(() -> new ConstituentFunctionNotFoundException("No " + NAMESPACES.FNOC + "constituentFunction present in " + NAMESPACES.FNOC + "mapFrom"));
            Optional<String> startingPointParameter = this.getObjectURI(startingPointResource.get(), NAMESPACES.FNOC + "functionParameter");
            boolean isOutput = false;
            if (!startingPointParameter.isPresent()) {
                startingPointParameter = this.getObjectURI(startingPointResource.get(), NAMESPACES.FNOC + "functionOutput");
                isOutput = true;
            }
            String predicateURI = this.parameterURItoPredicate.get(startingPointParameter.orElseThrow(() -> new MappingParameterNotFoundException("starting point: no output predicate found for mapping with constituent function " + startingPointFunction.getURI()){}));
            return new CompositionMappingPoint(startingPointFunction.getURI(), predicateURI, isOutput);
        }
        Literal literal = this.getLiteral(element, NAMESPACES.FNOC + "mapFromTerm").orElseThrow(() -> new CompositionStartingPointNotFound("No composition starting point found for " + element.getId()){});
        CompositionMappingPoint cmp = new CompositionMappingPoint("", literal.getString(), false);
        cmp.setLiteral(true);
        return cmp;
    }

    private CompositionMappingPoint parseCompositionMapElementEndpoint(Resource element) throws FnOException {
        Resource endPointResource = this.getObjectResource(element, NAMESPACES.FNOC + "mapTo").orElseThrow(() -> new CompositionEndPointNotFound("No mapping end point found"){});
        String id = this.getObjectURI(endPointResource, NAMESPACES.FNOC + "constituentFunction").orElseThrow(() -> new ConstituentFunctionNotFoundException("No Constituent function found for endpoint"){});
        Optional<String> parameterId = this.getObjectURI(endPointResource, NAMESPACES.FNOC + "functionParameter");
        boolean isOutput = false;
        if (!parameterId.isPresent()) {
            parameterId = this.getObjectURI(endPointResource, NAMESPACES.FNOC + "functionOutput");
            isOutput = true;
        }
        String predicateURI = this.parameterURItoPredicate.get(parameterId.orElseThrow(() -> new MappingParameterNotFoundException("mapping end point: no parameter found for constituent function " + id){}));
        return new CompositionMappingPoint(id, predicateURI, isOutput);
    }

    private void parseApplies() throws AppliesNotFoundException {
        logger.debug("Parsing fnoc:applies");
        HashMap<String, String> appliesMap = new HashMap<String, String>();
        Property appliesObject = ResourceFactory.createProperty((String)(NAMESPACES.FNOC + "applies"));
        ResIterator applies = this.functionDescriptionTriples.listSubjectsWithProperty(appliesObject);
        while (applies.hasNext()) {
            Resource alias = applies.nextResource();
            String original = this.getObjectURI(alias, NAMESPACES.FNOC + "applies").orElseThrow(() -> new AppliesNotFoundException("Could not find value for predicate '" + NAMESPACES.FNOC + "applies' of subject '" + alias + "'"));
            appliesMap.put(alias.getURI(), original);
        }
        for (String first : appliesMap.keySet()) {
            if (this.functionId2Functions.containsKey(first)) continue;
            String key = first;
            while (appliesMap.containsKey(key)) {
                key = (String)appliesMap.get(key);
            }
            this.functionId2Functions.put(first, this.functionId2Functions.get(key));
        }
    }

    private void parseFunctions() throws FnOException {
        logger.debug("Parsing functions");
        Resource functionObject = ResourceFactory.createResource((String)(NAMESPACES.FNO + "Function"));
        ResIterator functions = this.functionDescriptionTriples.listSubjectsWithProperty(this.typeProperty, (RDFNode)functionObject);
        while (functions.hasNext()) {
            this.parseFunction(functions.nextResource());
        }
    }

    private void parseFunction(Resource functionResource) throws FnOException {
        String functionURI = functionResource.getURI();
        if (!this.functionId2Functions.containsKey(functionURI)) {
            logger.debug("Parsing new function {}", (Object)functionURI);
            String name = this.getLiteralStr(functionResource, NAMESPACES.FNO + "name").orElseThrow(() -> new FunctionNameNotFoundException("Could not find '" + NAMESPACES.FNO + "name' for " + functionURI));
            List<Parameter> expects = this.parseParameters(functionResource, true);
            List<Parameter> returns = this.parseParameters(functionResource, false);
            String description = this.getLiteralStr(functionResource, NAMESPACES.DCTERMS + "description").orElse("");
            this.parseLib(functionResource);
            Function function = new Function(functionURI, name, description, expects, returns);
            this.functionId2Functions.put(functionURI, function);
        }
    }

    private List<Parameter> parseParameters(Resource functionResource, boolean input) throws FnOException {
        logger.debug("Parsing expected parameters of {}", (Object)functionResource.getURI());
        String isInputParameter = input ? "expects" : "returns";
        Resource expectedOrReturnedResources = functionResource.getPropertyResourceValue(this.functionDescriptionTriples.getProperty(NAMESPACES.FNO.toString(), isInputParameter));
        List<Resource> parameterResourceList = this.getResourcesFromList(expectedOrReturnedResources);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(parameterResourceList.size());
        for (Resource parameterResource : parameterResourceList) {
            parameters.add(this.parseParameter(parameterResource));
        }
        return parameters;
    }

    private Parameter parseParameter(Resource parameterResource) throws FnOException {
        String uri = parameterResource.getURI();
        logger.debug("Parsing parameter {}", (Object)uri);
        String name = this.getLiteralStr(parameterResource, NAMESPACES.FNO + "name").orElseThrow(() -> new ParameterNameDescriptionNotFoundException("No '" + NAMESPACES.FNO + "name' found for parameter '" + uri + "'"));
        String typeUri = this.getObjectURI(parameterResource, NAMESPACES.FNO + "type").orElseThrow(() -> new DataTypeNotFoundException("No data type description found for parameter '" + uri + "\""));
        String predicateUri = this.getObjectURI(parameterResource, NAMESPACES.FNO + "predicate").orElseThrow(() -> new ParameterPredicateNotFoundException("No predicate description found for parameter '" + uri + "'"));
        ResourceFactory.createProperty((String)(NAMESPACES.FNO + "required"));
        boolean isRequired = this.getLiteralBoolean(parameterResource, NAMESPACES.FNO + "required").orElse(true);
        DataTypeConverter typeConverter = predicateUri.equals(NAMESPACES.RDF + "_nnn") ? new ListConverter() : this.dataTypeConverterProvider.getDataTypeConverter(typeUri);
        return new Parameter(name, predicateUri, typeConverter, isRequired);
    }

    private void parseLib(Resource functionResource) throws FnOException {
        Optional<Resource> libResourceOption = this.getObjectResource(functionResource, NAMESPACES.LIB + "providedBy");
        String functionUri = functionResource.getURI();
        if (this.functionId2functionMappings.containsKey(functionUri)) {
            logger.debug("Function mapping for {} already parsed", (Object)functionUri);
            return;
        }
        if (libResourceOption.isPresent()) {
            logger.warn("Using {}providedBy is deprecated. Using the implementation vocabulary (https://fno.io/vocabulary/implementation/index-en.html) is recommended", (Object)NAMESPACES.LIB);
            Resource libResource = libResourceOption.get();
            String location = this.getLiteralStr(libResource, NAMESPACES.LIB + "localLibrary").orElse("");
            String mappedLocation = this.location2otherLocationMap.getOrDefault(location, location);
            String className = this.getLiteralStr(libResource, NAMESPACES.LIB + "class").orElseThrow(() -> new ClassNameDescriptionNotFoundException("No '" + NAMESPACES.LIB + "class' found for '" + libResource.getURI() + "' for function '" + functionUri + "'"));
            String method = this.getLiteralStr(libResource, NAMESPACES.LIB + "method").orElseThrow(() -> new MethodMappingNotFoundException("No '" + NAMESPACES.LIB + "method' found for '" + libResource.getURI() + "' for function '" + functionUri + "'"));
            MethodMapping methodMapping = new MethodMapping(NAMESPACES.FNOM + "StringMethodMapping", method);
            Implementation implementation = new Implementation(className, mappedLocation);
            FunctionMapping functionMapping = new FunctionMapping(functionUri, methodMapping, implementation);
            this.functionId2functionMappings.put(functionUri, functionMapping);
        }
    }

    private Optional<Literal> getLiteral(Resource subject, String predicateURI) {
        Property property = ResourceFactory.createProperty((String)predicateURI);
        Statement statement = subject.getProperty(property);
        if (statement == null) {
            return Optional.empty();
        }
        return Optional.of(statement.getObject().asLiteral());
    }

    private Optional<String> getLiteralStr(Resource subject, String predicateURI) {
        Optional<Literal> objectLiteralResult = this.getLiteral(subject, predicateURI);
        return objectLiteralResult.map(Literal::getString);
    }

    private Optional<Boolean> getLiteralBoolean(Resource subject, String predicateURI) {
        Optional<Literal> objectLiteralResult = this.getLiteral(subject, predicateURI);
        return objectLiteralResult.map(Literal::getBoolean);
    }

    private Optional<String> getObjectURI(Resource subject, String predicateURI) {
        Optional<Resource> objectResourceOption = this.getObjectResource(subject, predicateURI);
        return objectResourceOption.map(Resource::getURI);
    }

    private Optional<Resource> getObjectResource(Resource subject, String predicateURI) {
        Property property = ResourceFactory.createProperty((String)predicateURI);
        Statement statement = subject.getProperty(property);
        if (statement == null) {
            return Optional.empty();
        }
        return Optional.of(statement.getObject().asResource());
    }

    private List<Resource> getObjectResources(Resource subject, String predicateURI) {
        Property property = ResourceFactory.createProperty((String)predicateURI);
        StmtIterator it = subject.listProperties(property);
        ArrayList<Resource> list = new ArrayList<Resource>();
        it.filterDrop(Objects::isNull);
        it.forEach(s -> list.add(s.getObject().asResource()));
        return list;
    }

    private List<Resource> getResourcesFromList(Resource listResource) {
        Optional<Resource> firstResource;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (!listResource.hasURI(NAMESPACES.RDF + "nil") && (firstResource = this.getObjectResource(listResource, NAMESPACES.RDF + "first")).isPresent()) {
            resources.add(firstResource.get());
            Optional<Resource> restResource = this.getObjectResource(listResource, NAMESPACES.RDF + "rest");
            restResource.ifPresent(resource -> resources.addAll(this.getResourcesFromList((Resource)resource)));
        }
        return resources;
    }
}

