/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.functions.agent;

import be.ugent.idlab.knows.functions.agent.Agent;
import be.ugent.idlab.knows.functions.agent.Arguments;
import be.ugent.idlab.knows.functions.agent.DescriptionGenerator;
import be.ugent.idlab.knows.functions.agent.dataType.DataTypeConverter;
import be.ugent.idlab.knows.functions.agent.dataType.DataTypeConverterException;
import be.ugent.idlab.knows.functions.agent.dataType.DataTypeConverterProvider;
import be.ugent.idlab.knows.functions.agent.exception.MissingRDFSeqIndexException;
import be.ugent.idlab.knows.functions.agent.functionIntantiation.Instantiator;
import be.ugent.idlab.knows.functions.agent.functionIntantiation.exception.MethodNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.NAMESPACES;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.FunctionNotFoundException;
import be.ugent.idlab.knows.functions.agent.model.Function;
import be.ugent.idlab.knows.functions.agent.model.FunctionMapping;
import be.ugent.idlab.knows.functions.agent.model.Implementation;
import be.ugent.idlab.knows.functions.agent.model.MethodMapping;
import be.ugent.idlab.knows.functions.agent.model.Parameter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentImpl
implements Agent {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Function> functionId2Function;
    private final Instantiator instantiator;
    private final Pattern seq_pattern = Pattern.compile(NAMESPACES.RDF + "_\\d+");

    public AgentImpl(Map<String, Function> functionId2Function, Instantiator instantiator) {
        this.functionId2Function = functionId2Function;
        this.instantiator = instantiator;
    }

    @Override
    public Object execute(String functionId, Arguments arguments) throws Exception {
        return this.execute(functionId, arguments, false);
    }

    @Override
    public Object execute(String functionId, Arguments arguments, boolean debug) throws Exception {
        Function function;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Execution debug mode: {}", (Object)debug);
            this.logger.debug("Executing function '{}' with arguments '{}'", (Object)functionId, (Object)arguments.toString());
        }
        if ((function = this.functionId2Function.get(functionId)) == null) {
            throw new FunctionNotFoundException("Function with id " + functionId + " not found");
        }
        if (function.isComposite()) {
            List<Object> values = this.getParameterValues(functionId, arguments, function);
            return this.instantiator.getCompositeMethod(functionId, debug).apply(this, values.toArray());
        }
        Method method = this.instantiator.getMethod(functionId);
        if (method != null) {
            List<Object> values = this.getParameterValues(functionId, arguments, function);
            return method.invoke(null, values.toArray());
        }
        throw new MethodNotFoundException("No method found for function " + function.getId() + " (" + function.getName() + ")");
    }

    private List<Object> getParameterValues(String functionId, Arguments arguments, Function function) throws MissingRDFSeqIndexException, DataTypeConverterException {
        ArrayList<Object> valuesInOrder = new ArrayList<Object>(arguments.size());
        for (Parameter argumentParameter : function.getArgumentParameters()) {
            Object convertedValue;
            this.logger.debug("finding value for parameter {}", (Object)argumentParameter.getId());
            Collection<Object> valueCollection = arguments.get(argumentParameter.getId());
            if (argumentParameter.getTypeConverter().getTypeCategory() == DataTypeConverter.TypeCategory.COLLECTION) {
                this.logger.debug("got collection argument!");
                if ((NAMESPACES.RDF + "_nnn").equals(argumentParameter.getId())) {
                    this.logger.debug("found sequential parameter (_nnn), looking for values");
                    Optional<Integer> optionalInteger = arguments.getArgumentNames().stream().filter(name -> this.seq_pattern.matcher((CharSequence)name).matches()).map(i -> Integer.parseInt(i.substring(NAMESPACES.RDF.toString().length() + 1))).max(Integer::compareTo);
                    if (!optionalInteger.isPresent()) {
                        valuesInOrder.add(null);
                        continue;
                    }
                    int max = optionalInteger.get();
                    Object[] values = new Object[max];
                    for (int i2 = 0; i2 < max; ++i2) {
                        Object value;
                        int finalI = i2 + 1;
                        values[i2] = value = arguments.get(NAMESPACES.RDF + "_" + finalI).stream().findFirst().orElseThrow(() -> new MissingRDFSeqIndexException("no parameter found for _" + finalI));
                    }
                    valuesInOrder.add(argumentParameter.getTypeConverter().convert(values));
                    continue;
                }
                convertedValue = argumentParameter.getTypeConverter().convert(valueCollection);
                valuesInOrder.add(convertedValue);
                continue;
            }
            if (valueCollection.isEmpty()) {
                this.logger.debug("No value found for parameter '{}' in function {}. Considering it to be 'null'.", (Object)argumentParameter.getId(), (Object)functionId);
                valuesInOrder.add(null);
                continue;
            }
            convertedValue = argumentParameter.getTypeConverter().convert(valueCollection.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Value expected for parameter '" + argumentParameter.getId() + "' in function '" + functionId + "'.")));
            valuesInOrder.add(convertedValue);
        }
        return valuesInOrder;
    }

    void executeToFile(String functionId, Arguments arguments, String fileName) throws Exception {
        this.executeToFile(functionId, arguments, fileName, false);
    }

    void executeToFile(String functionId, Arguments arguments, String fileName, boolean debug) throws Exception {
        this.constructResult(functionId, arguments, fileName, debug);
    }

    private void constructResult(String functionId, Arguments arguments, String filename, boolean debug) throws Exception {
        Model model = ModelFactory.createDefaultModel();
        Function function = this.functionId2Function.get(functionId);
        Object result = this.execute(functionId, arguments, debug);
        Resource executionResource = model.createResource(NAMESPACES.FNO + "execution").addProperty(ResourceFactory.createProperty((String)NAMESPACES.RDF.toString(), (String)"type"), (RDFNode)model.createResource(NAMESPACES.FNO + "Execution"));
        executionResource.addProperty(ResourceFactory.createProperty((String)NAMESPACES.FNO.toString(), (String)"executes"), (RDFNode)model.createResource(functionId));
        for (Parameter argumentParameter : function.getArgumentParameters()) {
            executionResource.addLiteral(ResourceFactory.createProperty((String)argumentParameter.getId()), (Object)arguments.get(argumentParameter.getId()).toString());
        }
        if (function.getReturnParameters().isEmpty()) {
            executionResource.addLiteral(ResourceFactory.createProperty((String)NAMESPACES.DCTERMS.toString(), (String)"description"), (Object)"Function has no output");
        } else {
            executionResource.addLiteral(ResourceFactory.createProperty((String)function.getReturnParameters().get(0).getId()), (Object)result.toString());
        }
        this.printModel(model, filename);
    }

    private void printModel(Model model, String filename) throws IOException {
        OutputStream stream = System.out;
        if (filename != null) {
            stream = Files.newOutputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
        }
        RDFDataMgr.write((OutputStream)stream, (Model)model, (Lang)Lang.TURTLE);
        if (filename != null) {
            ((OutputStream)stream).close();
        }
    }

    String loadFunction(Method javaFunction) {
        DataTypeConverterProvider dataTypeConverterProvider = new DataTypeConverterProvider();
        if (!Modifier.isStatic(javaFunction.getModifiers())) {
            throw new UnsupportedOperationException("Java function needs to be static");
        }
        String name = javaFunction.getName();
        Class<?> clazz = javaFunction.getDeclaringClass();
        String functionId = NAMESPACES.FNO + "javaFunction." + clazz.getName() + "." + name;
        if (this.functionId2Function.containsKey(functionId)) {
            this.logger.warn("loadFunction: already found a function with id {}. Overwriting...", (Object)functionId);
        }
        List<Parameter> parameters = this.loadParameters(javaFunction, dataTypeConverterProvider);
        List<Parameter> returnValues = this.loadReturnValue(javaFunction, dataTypeConverterProvider);
        Function function = new Function(functionId, name, "", parameters, returnValues);
        FunctionMapping functionMapping = this.loadFunctionMapping(javaFunction, functionId);
        function.setFunctionMapping(functionMapping);
        this.functionId2Function.put(functionId, function);
        this.logger.debug("added Java function to Agent with id: {}", (Object)functionId);
        return functionId;
    }

    private List<Parameter> loadParameters(Method javaFunction, DataTypeConverterProvider dataTypeConverterProvider) {
        java.lang.reflect.Parameter[] functionParameters;
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        for (java.lang.reflect.Parameter parameter : functionParameters = javaFunction.getParameters()) {
            String parameterId = NAMESPACES.FNO + javaFunction.getClass().getName() + javaFunction.getName() + parameter.getName();
            Parameter p = new Parameter(parameter.getName(), parameterId, dataTypeConverterProvider.getDataTypeConverter(parameter.getType().getName()), true);
            parameterList.add(p);
        }
        return parameterList;
    }

    private List<Parameter> loadReturnValue(Method javaFunction, DataTypeConverterProvider dataTypeConverterProvider) {
        Class<?> returnType = javaFunction.getReturnType();
        Parameter returnParameter = new Parameter(returnType.getName() + "Output", "", dataTypeConverterProvider.getDataTypeConverter(returnType.getName()), true);
        ArrayList<Parameter> returnValue = new ArrayList<Parameter>();
        returnValue.add(returnParameter);
        return returnValue;
    }

    private FunctionMapping loadFunctionMapping(Method javaFunction, String functionId) {
        MethodMapping methodMapping = new MethodMapping("fnom:StringMethodMapping", javaFunction.getName());
        Implementation implementation = new Implementation(javaFunction.getDeclaringClass().getName(), "");
        return new FunctionMapping(functionId, methodMapping, implementation);
    }

    List<String> getParameterPredicates(String functionId) {
        return this.functionId2Function.get(functionId).getArgumentParameters().stream().map(Parameter::getId).collect(Collectors.toList());
    }

    void writeModel(String filename) throws IOException {
        Model model = ModelFactory.createDefaultModel();
        for (Function function : this.functionId2Function.values()) {
            DescriptionGenerator.addFunctionToModel(model, function);
        }
        try (OutputStream outputStream = Files.newOutputStream(Paths.get(filename, new String[0]), new OpenOption[0]);){
            RDFDataMgr.write((OutputStream)outputStream, (Model)model, (Lang)Lang.TURTLE);
        }
    }

    @Override
    public void close() {
        this.instantiator.close();
    }
}

