/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.record;

import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.idlab.knows.dataio.record.RecordValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;

public class ExcelRecord
extends Record {
    private final Map<String, Object> data = new HashMap<String, Object>();
    private final Map<String, String> data_types = new HashMap<String, String>();

    public ExcelRecord(Row header, Row row) {
        if (header.getLastCellNum() > row.getLastCellNum()) {
            this.logger.warn("Header has more columns than this row, these will be filled with empty strings");
        }
        if (header.getLastCellNum() < row.getLastCellNum()) {
            this.logger.warn("Header has less columns than this row, these extra values will be ignored");
        }
        for (int i = 0; i < header.getLastCellNum(); ++i) {
            if (i < row.getLastCellNum()) {
                if (header.getCell(i) == null) continue;
                this.data.put(header.getCell(i).getStringCellValue(), this.getCellValue(row.getCell(i)));
                this.data_types.put(header.getCell(i).getStringCellValue(), ExcelRecord.getIRI(row.getCell(i)));
                continue;
            }
            this.data.put(header.getCell(i).getStringCellValue(), null);
            this.data_types.put(header.getCell(i).getStringCellValue(), "");
        }
    }

    private static String getIRI(Cell cell) {
        if (cell == null) {
            return "";
        }
        CellType cellType = cell.getCellType();
        return switch (cellType) {
            case CellType.NUMERIC -> {
                if (cell.getNumericCellValue() % 1.0 == 0.0) {
                    yield XSDDatatype.XSDinteger.getURI();
                }
                yield XSDDatatype.XSDdouble.getURI();
            }
            case CellType.BOOLEAN -> XSDDatatype.XSDboolean.getURI();
            default -> XSDDatatype.XSDstring.getURI();
        };
    }

    @Override
    public String getDataType(String value) {
        return this.data_types.getOrDefault(value, "");
    }

    @Override
    public Map<String, String> getDataTypes() {
        return this.data_types;
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExcelRecord excelSource = (ExcelRecord)obj;
        for (String value : this.data.keySet()) {
            if (this.get(value).equals(excelSource.get(value))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.data, this.data_types);
    }

    @Override
    public RecordValue get(String reference) {
        if (!this.data.containsKey(reference)) {
            return RecordValue.notFound(String.format("Mapping for %s not found", reference));
        }
        Object obj = this.data.get(reference);
        if (obj == null) {
            return RecordValue.empty();
        }
        return RecordValue.ok(obj);
    }

    private Object getCellValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        try {
            return switch (cell.getCellType()) {
                case CellType.NUMERIC -> {
                    double d = cell.getNumericCellValue();
                    if (d % 1.0 == 0.0) {
                        yield (int)d;
                    }
                    yield d;
                }
                case CellType.BOOLEAN -> cell.getBooleanCellValue();
                default -> cell.getStringCellValue();
            };
        }
        catch (Exception e) {
            this.logger.warn("Could not get cell value. Returning null.", (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return "ExcelRecord{data=" + String.valueOf(this.data) + ", data_types=" + String.valueOf(this.data_types) + "}";
    }
}

