/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.iterators;

import be.ugent.idlab.knows.dataio.access.Access;
import be.ugent.idlab.knows.dataio.iterators.SourceIterator;
import be.ugent.idlab.knows.dataio.iterators.xpath.SaxNamespaceResolver;
import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.idlab.knows.dataio.record.XMLRecord;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;

public class XMLSourceIterator
extends SourceIterator {
    private static final long serialVersionUID = 5027462468699419883L;
    private final Access access;
    private final String stringIterator;
    private transient XdmSequenceIterator<XdmItem> iterator;
    private transient XPathCompiler compiler;
    private int index = 0;

    public XMLSourceIterator(Access access, String stringIterator) throws Exception {
        this.access = access;
        this.stringIterator = stringIterator;
        this.bootstrap();
    }

    private void bootstrap() throws SQLException, IOException, ParserConfigurationException, TransformerException, SaxonApiException {
        Processor saxProcessor = new Processor(false);
        DocumentBuilder docBuilder = saxProcessor.newDocumentBuilder();
        try (InputStream in = this.access.getInputStream();){
            XdmNode document = docBuilder.build((Source)new StreamSource(in));
            this.compiler = saxProcessor.newXPathCompiler();
            this.compiler.setCaching(true);
            SaxNamespaceResolver.registerNamespaces(this.compiler, document);
            XdmValue result = this.compiler.evaluate(this.stringIterator, (XdmItem)document);
            this.iterator = result.iterator();
        }
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException, SQLException, ParserConfigurationException, SaxonApiException, TransformerException {
        inputStream.defaultReadObject();
        this.bootstrap();
    }

    @Override
    public Record next() {
        if (this.iterator.hasNext()) {
            return new XMLRecord(this.iterator.next(), this.compiler, this.index++);
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public void close() {
        this.iterator.close();
    }
}

