/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.compression;

import be.ugent.idlab.knows.dataio.compression.Compression;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZOutputStream;

public class Compressor {
    private final Compression compression;
    private final String compressedFileName;

    public Compressor(Compression compression, String compressedFileName) {
        this.compression = compression;
        this.compressedFileName = compressedFileName;
    }

    public Compressor(Compression compression) {
        this(compression, null);
    }

    public OutputStream compress(OutputStream outputStream) throws IOException {
        return switch (this.compression) {
            default -> throw new IncompatibleClassChangeError();
            case Compression.None -> outputStream;
            case Compression.GZip -> this.gzip(outputStream);
            case Compression.Zip -> this.zip(outputStream);
            case Compression.XZ -> this.xz(outputStream);
            case Compression.Tar, Compression.TarXZ, Compression.TarGZ -> throw new IOException("Compression type not yet implemented: " + String.valueOf((Object)this.compression));
        };
    }

    private OutputStream zip(OutputStream outputStream) throws IOException {
        if (this.compressedFileName == null) {
            throw new IOException("No name given for the archive entry. Please construct a Compressor with a non-null compressedFileName parameter.");
        }
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        zip.putNextEntry(new ZipEntry(this.compressedFileName));
        return zip;
    }

    private OutputStream tar(OutputStream outputStream) throws IOException {
        if (this.compressedFileName == null) {
            throw new IOException("No name given for the archive entry. Please construct a Compressor with a non-null compressedFileName parameter.");
        }
        TarOutputStream tar = new TarOutputStream(outputStream);
        TarEntry entry = new TarEntry(this.compressedFileName);
        tar.putNextEntry(entry);
        return tar;
    }

    private OutputStream gzip(OutputStream outputStream) throws IOException {
        return new GZIPOutputStream(outputStream);
    }

    private OutputStream xz(OutputStream outputStream) throws IOException {
        return new XZOutputStream(outputStream, (FilterOptions)new LZMA2Options());
    }
}

