/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.access;

import be.ugent.idlab.knows.dataio.access.Access;
import be.ugent.idlab.knows.dataio.access.DatabaseType;
import com.opencsv.CSVWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RDBAccess
implements Access {
    private static final String DOUBLE = "http://www.w3.org/2001/XMLSchema#double";
    private static final String VARBINARY = "http://www.w3.org/2001/XMLSchema#hexBinary";
    private static final String DECIMAL = "http://www.w3.org/2001/XMLSchema#decimal";
    private static final String INTEGER = "http://www.w3.org/2001/XMLSchema#integer";
    private static final String BOOLEAN = "http://www.w3.org/2001/XMLSchema#boolean";
    private static final String DATE = "http://www.w3.org/2001/XMLSchema#date";
    private static final String TIME = "http://www.w3.org/2001/XMLSchema#time";
    private static final String DATETIME = "http://www.w3.org/2001/XMLSchema#dateTime";
    private static final long serialVersionUID = 786349656223609949L;
    private String dsn;
    private final DatabaseType databaseType;
    private final String username;
    private final String password;
    private final String query;
    private final String contentType;
    private final Map<String, String> datatypes = new HashMap<String, String>();
    private final Properties connectionProperties;
    private static final Logger log = LoggerFactory.getLogger(RDBAccess.class);

    public RDBAccess(String dsn, DatabaseType databaseType, Properties connectionProperties, String query, String contentType) {
        this.dsn = dsn;
        this.databaseType = databaseType;
        this.connectionProperties = connectionProperties;
        this.query = query;
        this.username = (String)connectionProperties.get("user");
        this.password = (String)connectionProperties.get("password");
        this.contentType = contentType;
    }

    public RDBAccess(String dsn, DatabaseType databaseType, String username, String password, String query, String contentType) {
        this(dsn, databaseType, RDBAccess.createConnectionProperties(username, password), query, contentType);
    }

    private static Properties createConnectionProperties(String username, String password) {
        Properties connectionProperties = new Properties();
        connectionProperties.put("user", username);
        connectionProperties.put("password", password);
        return connectionProperties;
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b : bytes) {
            builder.append(String.format("%02X", b));
        }
        return builder.toString();
    }

    private static String normalizeData(String data, String dataType) {
        if (DOUBLE.equals(dataType)) {
            return data != null ? data.replace(".0", "") : null;
        }
        return data;
    }

    @Override
    public InputStream getInputStream() throws IOException, SQLException, ParserConfigurationException, TransformerException {
        InputStream inputStream;
        if (this.databaseType == DatabaseType.MYSQL) {
            StringBuilder parametersSB = new StringBuilder();
            boolean alreadySomeQueryParametersPresent = this.dsn.contains("?");
            if (alreadySomeQueryParametersPresent) {
                parametersSB.append("&");
            } else {
                parametersSB.append("?");
            }
            parametersSB.append("serverTimezone=UTC&useSSL=false");
            this.dsn = this.dsn + String.valueOf(parametersSB);
        }
        if (this.databaseType == DatabaseType.SQL_SERVER) {
            this.dsn = this.dsn.replaceAll("[?&]", ";");
        }
        try (Connection connection = DriverManager.getConnection(this.dsn, this.connectionProperties);
             Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery(this.query);){
            inputStream = "http://semweb.mmlab.be/ns/ql#XPath".equals(this.contentType) ? this.getXMLInputStream(rs) : this.getCSVInputStream(rs);
        }
        return inputStream;
    }

    @Override
    public Map<String, String> getDataTypes() {
        return this.datatypes;
    }

    private InputStream getCSVInputStream(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        boolean filledInDataTypes = false;
        StringWriter writer = new StringWriter();
        CSVWriter csvWriter = new CSVWriter((Writer)writer);
        csvWriter.writeNext(this.getCSVHeader(rsmd, columnCount));
        while (rs.next()) {
            String[] csvRow = new String[columnCount];
            for (int i = 1; i <= columnCount; ++i) {
                Object data;
                String columnName = rsmd.getColumnLabel(i);
                String dataType = this.getColumnDataType(rsmd.getColumnTypeName(i));
                if (!filledInDataTypes && dataType != null) {
                    this.datatypes.put(columnName, dataType);
                }
                if (VARBINARY.equals(dataType)) {
                    data = rs.getBytes(columnName);
                    csvRow[i - 1] = RDBAccess.bytesToHexString(data);
                    continue;
                }
                data = rs.getString(columnName);
                csvRow[i - 1] = RDBAccess.normalizeData((String)data, dataType);
            }
            csvWriter.writeNext(csvRow);
            filledInDataTypes = true;
        }
        try {
            csvWriter.close();
        }
        catch (IOException e) {
            log.warn("Could not close CSVWriter.", (Throwable)e);
        }
        return new ByteArrayInputStream(writer.toString().getBytes());
    }

    private InputStream getXMLInputStream(ResultSet rs) throws SQLException, TransformerException, ParserConfigurationException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        StringWriter writer = new StringWriter();
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.newDocument();
        Element rootElement = doc.createElement("Results");
        doc.appendChild(rootElement);
        while (rs.next()) {
            Element row = doc.createElement("row");
            rootElement.appendChild(row);
            for (int i = 1; i <= columnCount; ++i) {
                Element el = doc.createElement(rsmd.getColumnName(i));
                el.appendChild(doc.createTextNode(rs.getObject(i).toString()));
                row.appendChild(el);
            }
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        return new ByteArrayInputStream(writer.toString().getBytes());
    }

    private String getColumnDataType(String type) {
        return switch (type.toUpperCase()) {
            case "BYTEA", "BINARY", "BINARY VARYING", "BINARY LARGE OBJECT", "VARBINARY" -> VARBINARY;
            case "NUMERIC", "DECIMAL" -> DECIMAL;
            case "SMALLINT", "INT", "INT4", "INT8", "INTEGER", "BIGINT" -> INTEGER;
            case "FLOAT", "FLOAT4", "FLOAT8", "REAL", "DOUBLE", "DOUBLE PRECISION" -> DOUBLE;
            case "BIT", "BOOL", "BOOLEAN" -> BOOLEAN;
            case "DATE" -> DATE;
            case "TIME" -> TIME;
            case "TIMESTAMP", "DATETIME" -> DATETIME;
            default -> null;
        };
    }

    private String[] getCSVHeader(ResultSetMetaData rsmd, int columnCount) throws SQLException {
        String[] headers = new String[columnCount];
        for (int i = 1; i <= columnCount; ++i) {
            headers[i - 1] = rsmd.getColumnLabel(i);
            if (headers[i - 1] != null && !headers[i - 1].isEmpty()) continue;
            headers[i - 1] = "be.ugent.rml.access.RDBAccess.nullheader";
        }
        return headers;
    }

    public boolean equals(Object o) {
        if (o instanceof RDBAccess) {
            RDBAccess access = (RDBAccess)o;
            return this.dsn.equals(access.getDSN()) && this.databaseType.equals((Object)access.getDatabaseType()) && this.username.equals(access.getUsername()) && this.password.equals(access.getPassword()) && this.query.equals(access.getQuery()) && this.contentType.equals(access.getContentType());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.getDSN() + String.valueOf((Object)this.getDatabaseType()) + this.getUsername() + this.getPassword() + this.getQuery() + this.getContentType());
    }

    public String getDSN() {
        return this.dsn;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getQuery() {
        return this.query;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getAccessPath() {
        return this.getDSN();
    }
}

