/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.access;

import be.ugent.idlab.knows.dataio.access.Access;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.spec.ECParameterSpec;
import java.sql.SQLException;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jose4j.jwk.EcJwkGenerator;
import org.jose4j.jwk.EllipticCurveJsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.keys.EllipticCurves;
import org.jose4j.lang.JoseException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPRequestAccess
implements Access {
    private static final Logger log = LoggerFactory.getLogger(HTTPRequestAccess.class);
    private final Map<String, String> credentialsCache = new HashMap<String, String>();
    private final Map<String, JSONObject> accessTokenCache = new HashMap<String, JSONObject>();
    protected String requestURL;
    protected String methodName;
    protected String methodBody;
    protected Map<String, String> auth;
    protected Map<String, String> headers;
    protected HttpClient httpClient = HttpClient.newBuilder().build();
    private final EllipticCurveJsonWebKey jwk;

    public HTTPRequestAccess(String requestURL) {
        this(requestURL, "GET", null, Map.of(), Map.of());
    }

    public HTTPRequestAccess(String requestURL, String methodName, String methodBody, Map<String, String> headers, Map<String, String> auth) {
        this.requestURL = requestURL;
        this.methodName = methodName;
        this.auth = auth;
        this.headers = headers;
        this.methodBody = methodBody;
        try {
            this.jwk = EcJwkGenerator.generateJwk((ECParameterSpec)EllipticCurves.P256);
        }
        catch (JoseException e) {
            throw new RuntimeException(e);
        }
    }

    public HTTPRequestAccess(String url, String method) {
        this(url, method, null, Map.of(), Map.of());
    }

    public HTTPRequestAccess(String url, String method, String body) {
        this(url, method, body, Map.of(), Map.of());
    }

    @Override
    public InputStream getInputStream() throws IOException, SQLException, ParserConfigurationException, TransformerException {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().version(HttpClient.Version.HTTP_1_1).uri(URI.create(this.requestURL));
        requestBuilder = this.methodBody != null ? requestBuilder.method(this.methodName, HttpRequest.BodyPublishers.ofString(this.methodBody)) : requestBuilder.method(this.methodName, HttpRequest.BodyPublishers.noBody());
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            requestBuilder.setHeader(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.auth.entrySet()) {
            requestBuilder.setHeader(entry.getKey(), entry.getValue());
        }
        try {
            HttpRequest request = requestBuilder.build();
            log.debug(request.uri().toString());
            HttpResponse<String> response = this.httpClient.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new RuntimeException("Could not reach the server: " + response.body());
            }
            return new ByteArrayInputStream(response.body().getBytes(StandardCharsets.UTF_8));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setAuth(Map<String, String> auth) {
        this.auth = auth;
    }

    public void setAuthSolid(String email, String password, String oidcIssuer, String authWebID) throws JoseException {
        this.auth = this.getAuthHeadersSolid(email, password, oidcIssuer, authWebID, this.requestURL, this.methodName);
    }

    @Override
    public Map<String, String> getDataTypes() {
        return Map.of();
    }

    @Override
    public String getContentType() {
        return "";
    }

    @Override
    public String getAccessPath() {
        return "";
    }

    public Map<String, String> getAuthHeadersSolid(String email, String password, String oidcIssuer, String webId, String uri, String method) throws JoseException {
        log.debug("Fetching dpop access token");
        String dpop = this.getDpopAccessToken(email, password, oidcIssuer, webId);
        log.debug("Constructing jwt");
        String dataJWT = this.generateJWT(uri, method);
        return Map.of("Authorization", "DPoP " + dpop, "DPoP", dataJWT);
    }

    private String getDpopAccessToken(String email, String password, String oidcIssuer, String webId) {
        String clientCredentials = this.credentialsCache.containsKey(oidcIssuer) ? this.credentialsCache.get(oidcIssuer) : this.fetchClientCredentials(email, password, oidcIssuer, webId);
        String accessToken = null;
        boolean isValidToken = false;
        if (this.accessTokenCache.containsKey(webId)) {
            JSONObject token = new JSONObject((Object)this.accessTokenCache.get(webId));
            long expiry = token.getLong("expires_on");
            long now = new Date().getTime() / 1000L;
            if (now < expiry - 10L) {
                accessToken = token.getString("access_token");
                isValidToken = true;
            }
        }
        if (!isValidToken) {
            accessToken = this.fetchAccessToken(oidcIssuer, webId, clientCredentials);
        }
        return accessToken;
    }

    private String fetchAccessToken(String oidcIssuer, String webId, String clientCredentials) {
        try {
            JSONObject creds = new JSONObject(clientCredentials);
            String id = creds.getString("id");
            String secret = creds.getString("secret");
            HttpRequest request = HttpRequest.newBuilder().version(HttpClient.Version.HTTP_1_1).uri(URI.create(oidcIssuer + ".well-known/openid-configuration")).GET().build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IllegalStateException("Could not get OpenID Connect info: " + response.body());
            }
            JSONObject oidcInfo = new JSONObject(response.body());
            String tokenEndpoint = oidcInfo.getString("token_endpoint");
            String dpopJWT = this.generateJWT(tokenEndpoint, "POST");
            String concatCredentials = id + ":" + secret;
            String base64ClientCredentials = Base64.getEncoder().encodeToString(concatCredentials.getBytes(StandardCharsets.UTF_8));
            request = HttpRequest.newBuilder().version(HttpClient.Version.HTTP_1_1).uri(URI.create(tokenEndpoint)).POST(HttpRequest.BodyPublishers.ofString("grant_type=client_credentials&scope=webid", StandardCharsets.UTF_8)).setHeader("Authorization", "Basic " + base64ClientCredentials).setHeader("Content-Type", "application/x-www-form-urlencoded").setHeader("DPoP", dpopJWT).build();
            response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IllegalStateException("Could not get OpenID Connect info: " + response.body());
            }
            long start = new Date().getTime() / 1000L;
            JSONObject accessTokenObj = new JSONObject(response.body());
            accessTokenObj.put("expires_on", start + (long)accessTokenObj.getInt("expires_in"));
            this.accessTokenCache.put(webId, accessTokenObj);
            return accessTokenObj.getString("access_token");
        }
        catch (IOException | InterruptedException | JoseException e) {
            throw new RuntimeException(e);
        }
    }

    private String generateJWT(String url, String method) throws JoseException {
        JwtClaims claims = new JwtClaims();
        claims.setGeneratedJwtId();
        claims.setClaim("htm", (Object)method);
        claims.setClaim("htu", (Object)url);
        claims.setIssuedAtToNow();
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claims.toJson());
        jws.setKey((Key)this.jwk.getPrivateKey());
        jws.setAlgorithmHeaderValue("ES256");
        jws.setHeader("typ", "dpop+jwt");
        jws.setJwkHeader((PublicJsonWebKey)this.jwk);
        jws.sign();
        return jws.getCompactSerialization();
    }

    private String fetchClientCredentials(String email, String password, String oidcIssuer, String webId) {
        log.debug("Fetching client credentials");
        try {
            log.debug("Fetching account info");
            HttpRequest request = HttpRequest.newBuilder().version(HttpClient.Version.HTTP_1_1).uri(URI.create(oidcIssuer + ".account/")).GET().build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IllegalStateException("Could not get account info: " + response.body());
            }
            log.debug("Getting password login URL");
            JSONObject accountInfo = new JSONObject(response.body());
            String passwordURL = accountInfo.getJSONObject("controls").getJSONObject("password").getString("login");
            log.debug("Logging in");
            String message = new JSONObject(Map.of("email", email, "password", password)).toString();
            request = HttpRequest.newBuilder().version(HttpClient.Version.HTTP_1_1).uri(URI.create(passwordURL)).POST(HttpRequest.BodyPublishers.ofString(message, StandardCharsets.UTF_8)).setHeader("Content-Type", "application/json").build();
            response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IllegalStateException("Could not log in: " + response.body());
            }
            JSONObject loginInfo = new JSONObject(response.body());
            String authToken = loginInfo.getString("authorization");
            log.debug("Got authorization token");
            request = HttpRequest.newBuilder().version(HttpClient.Version.HTTP_1_1).uri(URI.create(oidcIssuer + ".account/")).GET().setHeader("Authorization", "CSS-Account-Token " + authToken).build();
            response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IllegalStateException("Could not get account info even after logging in: " + response.body());
            }
            JSONObject authAccountInfo = new JSONObject(response.body());
            String credentialsURL = authAccountInfo.getJSONObject("controls").getJSONObject("account").getString("clientCredentials");
            message = new JSONObject(Map.of("name", "my-token", "webId", webId)).toString();
            request = HttpRequest.newBuilder().version(HttpClient.Version.HTTP_1_1).uri(URI.create(credentialsURL)).POST(HttpRequest.BodyPublishers.ofString(message, StandardCharsets.UTF_8)).setHeader("Content-Type", "application/json").setHeader("Authorization", "CSS-Account-Token " + authToken).build();
            response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IllegalStateException("Could not get OpenID Connect token info: " + response.body());
            }
            log.debug("Obtained credentials");
            String credentials = response.body();
            this.credentialsCache.put(webId, credentials);
            return credentials;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

