/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.record;

import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.idlab.knows.dataio.record.RecordValue;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsfr.json.compiler.JsonPathCompiler;
import org.jsfr.json.path.JsonPath;
import org.jsfr.json.path.PathOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONRecord
extends Record {
    private final Object document;
    private final String tag;
    private final String path;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<String> compiledPath;

    public JSONRecord(Object document, String tag) {
        this(document, tag, "");
    }

    public JSONRecord(Object document, String tag, String path) {
        this.document = document;
        this.tag = tag;
        this.path = path;
    }

    @Override
    public RecordValue get(String reference) {
        if (reference.startsWith("\\_")) {
            return this.processMagicProperty(reference);
        }
        if (this.document instanceof ValueNode && reference.equals("@")) {
            String v = ((ValueNode)this.document).asText();
            return RecordValue.ok(v);
        }
        if (reference.startsWith("\"") && reference.endsWith("\"")) {
            reference = reference.substring(1, reference.length() - 1);
        }
        if (reference.contains(" ")) {
            reference = String.format("['%s']", reference);
        }
        if (!reference.contains("$")) {
            String string = reference = reference.startsWith(".") ? String.format("$%s", reference) : String.format("$.%s", reference);
        }
        if (reference.equals("@")) {
            reference = "";
        }
        try {
            Object result = com.jayway.jsonpath.JsonPath.read((Object)this.document, (String)reference, (Predicate[])new Predicate[0]);
            if (result != null) {
                return RecordValue.ok(result);
            }
            return RecordValue.empty();
        }
        catch (PathNotFoundException e) {
            String message = "JSONPath '" + this.path + reference + "': " + e.getMessage();
            this.logger.warn(message, (Throwable)e);
            return RecordValue.notFound(message);
        }
        catch (JsonPathException e) {
            String message = "JSONPath '" + this.path + reference + "': " + e.getMessage();
            this.logger.warn(message, (Throwable)e);
            return RecordValue.error(message);
        }
    }

    private RecordValue processMagicProperty(String reference) {
        if (reference.startsWith("\\_PATH")) {
            return this.processPath(reference);
        }
        return RecordValue.error(String.format("Unknown magic property %s", reference));
    }

    private RecordValue processPath(String reference) {
        Pattern pattern;
        Matcher matcher;
        if (this.path.isEmpty()) {
            return RecordValue.empty();
        }
        if (this.compiledPath == null) {
            this.compilePath();
        }
        if ((matcher = (pattern = Pattern.compile("_PATH\\[(\\d+)]")).matcher(reference)).find()) {
            return this.processPathIndex(Integer.parseInt(matcher.group(1)));
        }
        return this.constructPath();
    }

    private RecordValue constructPath() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.compiledPath.get(0));
        for (int i = 1; i < this.compiledPath.size(); ++i) {
            builder.append(",");
            builder.append(this.compiledPath.get(i));
        }
        builder.append("]");
        return RecordValue.ok(builder.toString());
    }

    private void compilePath() {
        JsonPath jsonPath = JsonPathCompiler.compile((String)this.path);
        this.compiledPath = new ArrayList<String>();
        for (int i = jsonPath.pathDepth() - 1; i >= 0; --i) {
            PathOperator operator = jsonPath.get(i);
            String operatorString = operator.toString();
            if (operator.getType().equals((Object)PathOperator.Type.ARRAY)) {
                int length = operatorString.length();
                this.compiledPath.add(operatorString.substring(1, length - 1));
                continue;
            }
            if (!operator.getType().equals((Object)PathOperator.Type.OBJECT)) continue;
            this.compiledPath.add(operatorString.substring(1));
        }
    }

    private RecordValue processPathIndex(int index) {
        return RecordValue.ok(this.compiledPath.get(index));
    }

    public String getTag() {
        return this.tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSONRecord that = (JSONRecord)o;
        return this.path.equals(that.path) && this.document.equals(that.document);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.path, this.document);
    }
}

