/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.iterators;

import be.ugent.idlab.knows.dataio.access.Access;
import be.ugent.idlab.knows.dataio.iterators.SourceIterator;
import be.ugent.idlab.knows.dataio.record.ExcelRecord;
import be.ugent.idlab.knows.dataio.record.Record;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelSourceIterator
extends SourceIterator {
    private static final long serialVersionUID = 5223150147849184514L;
    private final Access access;
    private transient Iterator<ExcelRecord> iterator;

    public ExcelSourceIterator(Access access) throws Exception {
        this.access = access;
        this.boostrap();
    }

    private void boostrap() throws Exception {
        ArrayList sources = new ArrayList();
        try (InputStream in = this.access.getInputStream();
             XSSFWorkbook wb = new XSSFWorkbook(in);){
            for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                Sheet sheet = wb.getSheetAt(i);
                Iterator iterator = sheet.iterator();
                if (!iterator.hasNext()) continue;
                Row header = (Row)iterator.next();
                iterator.forEachRemaining((? super E row) -> sources.add(new ExcelRecord(header, (Row)row)));
            }
        }
        this.iterator = sources.iterator();
    }

    private void readObject(ObjectInputStream inputStream) throws Exception {
        inputStream.defaultReadObject();
        this.boostrap();
    }

    @Override
    public Record next() {
        return this.iterator.next();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public void close() throws IOException {
    }
}

