/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.access;

import be.ugent.idlab.knows.dataio.access.Access;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.riot.RDFDataMgr;

public class SPARQLLocalFileAccess
implements Access,
AutoCloseable {
    private static final long serialVersionUID = -4392563969906913155L;
    private final String query;
    private final String pathToFile;
    private final String contentType;

    public SPARQLLocalFileAccess(String pathToFile, String query, String contentType) {
        this.pathToFile = pathToFile;
        this.query = query;
        this.contentType = contentType;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        Dataset data = RDFDataMgr.loadDataset((String)this.pathToFile);
        try (QueryExecution qexec = QueryExecutionFactory.create((String)this.query, (Dataset)data);){
            ByteArrayInputStream byteArrayInputStream;
            ResultSet results = qexec.execSelect();
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                if (this.contentType.contains("json")) {
                    ResultSetFormatter.outputAsJSON((OutputStream)out, (ResultSet)results);
                } else if (this.contentType.contains("xml")) {
                    ResultSetFormatter.outputAsXML((OutputStream)out, (ResultSet)results);
                } else {
                    ResultSetFormatter.outputAsCSV((OutputStream)out, (ResultSet)results);
                }
                byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            }
            return byteArrayInputStream;
        }
    }

    @Override
    public Map<String, String> getDataTypes() {
        return null;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getAccessPath() {
        return this.pathToFile;
    }

    @Override
    public void close() {
    }
}

