/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart.data;

import be.ceau.chart.dataset.Dataset;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class Data<D extends Data<D, T, O>, T extends Dataset<T, O>, O> {
    private final List<String> labels = new ArrayList<String>();
    private final List<T> datasets = new ArrayList<T>();

    public List<String> getLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    public D setLabels(Collection<String> labels) {
        this.labels.clear();
        if (labels != null) {
            this.labels.addAll(labels);
        }
        return (D)this;
    }

    public D setLabels(String ... labels) {
        this.labels.clear();
        if (labels != null) {
            this.labels.addAll(Arrays.asList(labels));
        }
        return (D)this;
    }

    public D clearLabels() {
        this.labels.clear();
        return (D)this;
    }

    public D addLabel(String label) {
        this.labels.add(label);
        return (D)this;
    }

    public D addLabels(String ... label) {
        this.labels.addAll(Arrays.asList(label));
        return (D)this;
    }

    public List<T> getDatasets() {
        return Collections.unmodifiableList(this.datasets);
    }

    public D setDatasets(Collection<T> datasets) {
        this.datasets.clear();
        if (datasets != null) {
            this.datasets.addAll(datasets);
        }
        return (D)this;
    }

    public D addDataset(T dataset) {
        this.datasets.add(dataset);
        return (D)this;
    }
}

