/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart;

import be.ceau.chart.Chart;
import be.ceau.chart.data.BarData;
import be.ceau.chart.dataset.BarDataset;
import be.ceau.chart.options.BarOptions;
import be.ceau.chart.options.scales.XAxis;
import be.ceau.chart.options.scales.YAxis;
import be.ceau.chart.options.ticks.LinearTicks;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class BarChart
implements Chart {
    private static final ObjectWriter WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter().forType(BarChart.class);
    @JsonIgnore
    private boolean vertical = true;
    private BarData data;
    private BarOptions options;

    public static BarData data() {
        return new BarData();
    }

    public static BarOptions options() {
        return new BarOptions();
    }

    public BarChart() {
    }

    public BarChart(BarData data) {
        this.data = data;
    }

    public BarChart(BarData data, BarOptions options) {
        this.data = data;
        this.options = options;
    }

    public BarData getData() {
        return this.data;
    }

    public BarChart setData(BarData data) {
        this.data = data;
        return this;
    }

    public BarOptions getOptions() {
        return this.options;
    }

    public BarChart setOptions(BarOptions options) {
        this.options = options;
        return this;
    }

    public BarChart setHorizontal() {
        this.vertical = false;
        return this;
    }

    public boolean isHorizontal() {
        return !this.vertical;
    }

    public BarChart setVertical() {
        this.vertical = true;
        return this;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.vertical ? "bar" : "horizontalBar";
    }

    @Override
    public String toJson() {
        try {
            return WRITER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isDrawable() {
        if (this.data.getLabels().isEmpty()) {
            return false;
        }
        boolean sufficientData = false;
        for (BarDataset dataset : this.data.getDatasets()) {
            if (dataset.getXAxisID() != null && !this.hasXAxisWithId(dataset.getXAxisID())) {
                return false;
            }
            if (dataset.getYAxisID() != null && !this.hasYAxisWithId(dataset.getYAxisID())) {
                return false;
            }
            if (dataset.getData().size() <= 0) continue;
            sufficientData = true;
        }
        return sufficientData;
    }

    private boolean hasXAxisWithId(String id) {
        if (this.options != null && this.options.getScales() != null && this.options.getScales().getxAxes() != null) {
            for (XAxis<LinearTicks> xAxis : this.options.getScales().getxAxes()) {
                if (!id.equals(xAxis.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasYAxisWithId(String id) {
        if (this.options != null && this.options.getScales() != null && this.options.getScales().getyAxes() != null) {
            for (YAxis<LinearTicks> yAxis : this.options.getScales().getyAxes()) {
                if (!id.equals(yAxis.getId())) continue;
                return true;
            }
        }
        return false;
    }
}

